/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.page.extension;

import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestJQuerySelectorEngineInjectedInNoConflictWay {
    private static final String EXPECTED_$_OBJECT_VALUE = "something different than JQuery object";
    private static final String EXPECTED_JQUERY_OBJECT_VALUE = "way different";
    @ArquillianResource
    private URL contextRoot;
    @FindByJQuery(value="#placeholder")
    private WebElement placeholder;
    @FindByJQuery(value=":button")
    private WebElement show$ObjectValue;
    @FindByJQuery(value=":button:eq(1)")
    private WebElement showJQueryObjectValue;
    @Drone
    private WebDriver browser;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("sampleJQueryLocatorNoConflict.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void test$ObejctWasNotInvadedByIncludedJQuery() {
        this.show$ObjectValue.click();
        String placeholderText = this.placeholder.getText();
        Assert.assertEquals((String)"The installed JQuery for sizzle locators invades predefined global variable $!", (Object)EXPECTED_$_OBJECT_VALUE, (Object)placeholderText);
    }

    @Test
    public void testJQueryObjectWasNotInvadedByIncludedJQuery() {
        this.showJQueryObjectValue.click();
        String placeholderText = this.placeholder.getText();
        Assert.assertEquals((String)"The installed JQuery for sizzle locators invades predefined global variable jQuery!", (Object)EXPECTED_JQUERY_OBJECT_VALUE, (Object)placeholderText);
    }
}

