/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.parallel;

import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.ftest.parallel.AbstractParallelTest;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Before;
import org.junit.Test;
import qualifier.Browser1;
import qualifier.Browser2;

public class TestInterceptors
extends AbstractParallelTest {
    @Browser1
    @ArquillianResource
    private GrapheneContext context1;
    @Browser2
    @ArquillianResource
    private GrapheneContext context2;
    @ArquillianResource
    private GrapheneContext contextDefault;
    private AtomicInteger counter1 = new AtomicInteger();
    private AtomicInteger counter2 = new AtomicInteger();
    private AtomicInteger counterDefault = new AtomicInteger();

    @Before
    public void resetCounters() {
        this.counter1.set(0);
        this.counter2.set(0);
        this.counterDefault.set(0);
    }

    @Test
    public void testContextVsDrone() {
        ((GrapheneProxyInstance)this.browser1).registerInterceptor(this.createInterceptor(this.counter1));
        ((GrapheneProxyInstance)this.browser2).registerInterceptor(this.createInterceptor(this.counter2));
        ((GrapheneProxyInstance)this.browserDefault).registerInterceptor(this.createInterceptor(this.counterDefault));
        this.context1.getWebDriver(new Class[0]).getTitle();
        this.context2.getWebDriver(new Class[0]).getTitle();
        this.contextDefault.getWebDriver(new Class[0]).getTitle();
        Assert.assertEquals((int)1, (int)this.counter1.get());
        Assert.assertEquals((int)1, (int)this.counter2.get());
        Assert.assertEquals((int)1, (int)this.counterDefault.get());
    }

    protected Interceptor createInterceptor(final AtomicInteger counter) {
        return new Interceptor(){

            public Object intercept(InvocationContext context) throws Throwable {
                counter.incrementAndGet();
                return context.invoke();
            }

            public int getPrecedence() {
                return 0;
            }
        };
    }
}

