/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.parallel;

import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.ftest.parallel.AbstractParallelTest;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.page.document.Document;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import qualifier.Browser1;
import qualifier.Browser2;

@RunWith(value=Arquillian.class)
public class TestPageObjects
extends AbstractParallelTest {
    @Page
    @Browser1
    private SimplePage page1;
    @Page
    @Browser2
    private SimplePage page2;
    @Page
    private SimplePage pageDefault;

    @Test
    public void testNotNull() {
        this.assertPagesNotNull(this.page1, this.page2, this.pageDefault);
    }

    @Test
    public void testMethodParamsNotNull(@Page @Browser1 SimplePage paramPage1, @Page @Browser2 SimplePage paramPage2, @Page SimplePage paramPageDefault) {
        this.assertPagesNotNull(paramPage1, paramPage2, paramPageDefault);
    }

    @Test
    public void testHeadersViaAttributes() {
        this.assertHeadersViaAttributes(this.page1, this.page2, this.pageDefault);
    }

    @Test
    public void testMethodParamsHeadersViaAttributes(@Page @Browser1 SimplePage paramPage1, @Page @Browser2 SimplePage paramPage2, @Page SimplePage paramPageDefault) {
        this.assertHeadersViaAttributes(paramPage1, paramPage2, paramPageDefault);
    }

    @Test
    public void testHeadersViaMethod() {
        this.assertHeadersViaMethod(this.page1, this.page2, this.pageDefault);
    }

    @Test
    public void testMethodParamsHeadersViaMethod(@Page @Browser1 SimplePage paramPage1, @Page @Browser2 SimplePage paramPage2, @Page SimplePage paramPageDefault) {
        this.assertHeadersViaMethod(paramPage1, paramPage2, paramPageDefault);
    }

    @Test
    public void testDroneInPageObjects() {
        this.assertDroneInPageObjects(this.page1, this.page2, this.pageDefault);
    }

    @Test
    public void testMethodParamDroneInPageObjects(@Page @Browser1 SimplePage paramPage1, @Page @Browser2 SimplePage paramPage2, @Page SimplePage paramPageDefault) {
        this.assertDroneInPageObjects(paramPage1, paramPage2, paramPageDefault);
    }

    @Test
    public void testJavaScriptInterfaceInPageObjects() {
        this.assertJavaScriptInterfaceInPageObjects(this.page1, this.page2, this.pageDefault);
    }

    @Test
    public void testMethodParamJavaScriptInterfaceInPageObjects(@Page @Browser1 SimplePage paramPage1, @Page @Browser2 SimplePage paramPage2, @Page SimplePage paramPageDefault) {
        this.assertJavaScriptInterfaceInPageObjects(paramPage1, paramPage2, paramPageDefault);
    }

    @Test
    public void testJavaScriptExecutorInPageObjects() {
        this.assertJavaScriptExecutorInPageObjects(this.page1, this.page2, this.pageDefault);
    }

    @Test
    public void testMethodParamJavaScriptExecutorInPageObjects(@Page @Browser1 SimplePage paramPage1, @Page @Browser2 SimplePage paramPage2, @Page SimplePage paramPageDefault) {
        this.assertJavaScriptExecutorInPageObjects(paramPage1, paramPage2, paramPageDefault);
    }

    @Test
    public void testGrapheneContextQualifier() {
        this.assertGrapheneContextQualifier(this.page1, this.page2, this.pageDefault);
    }

    @Test
    public void testMethodParamGrapheneContextQualifier(@Page @Browser1 SimplePage paramPage1, @Page @Browser2 SimplePage paramPage2, @Page SimplePage paramPageDefault) {
        this.assertGrapheneContextQualifier(paramPage1, paramPage2, paramPageDefault);
    }

    private void assertPagesNotNull(SimplePage assertPage1, SimplePage assertPage2, SimplePage assertPageDefault) {
        Assert.assertNotNull((Object)assertPage1);
        Assert.assertNotNull((Object)assertPage2);
        Assert.assertNotNull((Object)assertPageDefault);
    }

    public void assertHeadersViaAttributes(SimplePage assertPage1, SimplePage assertPage2, SimplePage assertPageDefault) {
        Assert.assertNotNull((Object)assertPage1.header);
        Assert.assertNotNull((Object)assertPage2.header);
        Assert.assertNotNull((Object)assertPageDefault.header);
        Assert.assertEquals((Object)"Page 1", (Object)assertPage1.header.getText().trim());
        Assert.assertEquals((Object)"Page 2", (Object)assertPage2.header.getText().trim());
        Assert.assertEquals((Object)"Page Default", (Object)assertPageDefault.header.getText().trim());
    }

    public void assertHeadersViaMethod(SimplePage assertPage1, SimplePage assertPage2, SimplePage assertPageDefault) {
        Assert.assertNotNull((Object)assertPage1.header());
        Assert.assertNotNull((Object)assertPage2.header());
        Assert.assertNotNull((Object)assertPageDefault.header());
        Assert.assertEquals((Object)"Page 1", (Object)assertPage1.header().getText().trim());
        Assert.assertEquals((Object)"Page 2", (Object)assertPage2.header().getText().trim());
        Assert.assertEquals((Object)"Page Default", (Object)assertPageDefault.header().getText().trim());
    }

    public void assertDroneInPageObjects(SimplePage assertPage1, SimplePage assertPage2, SimplePage assertPageDefault) {
        String url1 = this.browser1.getCurrentUrl();
        String url2 = this.browser2.getCurrentUrl();
        String urlDefault = this.browserDefault.getCurrentUrl();
        Assert.assertNotNull((Object)assertPage1.browser());
        Assert.assertNotNull((Object)assertPage2.browser());
        Assert.assertNotNull((Object)assertPageDefault.browser());
        Assert.assertEquals((Object)url1, (Object)assertPage1.getCurrentURL());
        Assert.assertEquals((Object)url2, (Object)assertPage2.getCurrentURL());
        Assert.assertEquals((Object)urlDefault, (Object)assertPageDefault.getCurrentURL());
    }

    public void assertJavaScriptInterfaceInPageObjects(SimplePage assertPage1, SimplePage assertPage2, SimplePage assertPageDefault) {
        Assert.assertEquals((Object)"Page 1", (Object)assertPage1.getHeaderTextViaJavaScriptInterface().trim());
        Assert.assertEquals((Object)"Page 2", (Object)assertPage2.getHeaderTextViaJavaScriptInterface().trim());
        Assert.assertEquals((Object)"Page Default", (Object)assertPageDefault.getHeaderTextViaJavaScriptInterface().trim());
    }

    public void assertJavaScriptExecutorInPageObjects(SimplePage assertPage1, SimplePage assertPage2, SimplePage assertPageDefault) {
        Assert.assertEquals((Object)"Page 1", (Object)assertPage1.getTitleViaJavaScriptExecutor().trim());
        Assert.assertEquals((Object)"Page 2", (Object)assertPage2.getTitleViaJavaScriptExecutor().trim());
        Assert.assertEquals((Object)"Page Default", (Object)assertPageDefault.getTitleViaJavaScriptExecutor().trim());
    }

    public void assertGrapheneContextQualifier(SimplePage assertPage1, SimplePage assertPage2, SimplePage assertPageDefault) {
        Assert.assertEquals(Browser1.class, assertPage1.getQualifier());
        Assert.assertEquals(Browser2.class, assertPage2.getQualifier());
        Assert.assertEquals(Default.class, assertPageDefault.getQualifier());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimplePage {
        @FindBy(tagName="h1")
        private WebElement header;
        @JavaScript
        private Document document;
        @ArquillianResource
        private JavascriptExecutor javascriptExecutor;
        @ArquillianResource
        private GrapheneContext context;
        @Drone
        private WebDriver browser;

        public String getCurrentURL() {
            return this.browser.getCurrentUrl();
        }

        public String getTitleViaJavaScriptExecutor() {
            Object title = this.javascriptExecutor.executeScript("return document.title", new Object[0]);
            if (title == null) {
                return null;
            }
            return (String)title;
        }

        public String getHeaderTextViaJavaScriptInterface() {
            return ((WebElement)this.document.getElementsByTagName("h1").get(0)).getText().trim();
        }

        public Class<?> getQualifier() {
            return this.context.getQualifier();
        }

        public WebElement header() {
            return this.header;
        }

        public WebDriver browser() {
            return this.browser;
        }
    }
}

