/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.openqa.selenium.WebDriver;

public class Resource {
    final String location;

    Resource(String location) {
        this.location = location;
        if (Resource.class.getClassLoader().getResource(location) == null) {
            throw new IllegalArgumentException("Can't find the resource " + location + ".");
        }
    }

    public void loadPage(WebDriver browser, URL context) {
        browser.get(context.toString() + this.location);
    }

    public String toString() {
        return this.location;
    }

    public static ResourceBuilder inCurrentPackage() {
        try {
            String pkg = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName()).getPackage().getName();
            return new ResourceBuilder(pkg);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Can't load the current package.", e);
        }
    }

    public static ResourceBuilder inPackage(String pkg) {
        return new ResourceBuilder(pkg);
    }

    public static class ResourceBuilder {
        private final String pkg;

        public ResourceBuilder(String pkg) {
            this.pkg = pkg;
        }

        public Resource find(String name) {
            return new Resource(this.pkg.replace(".", "/") + "/" + name);
        }

        public Collection<Resource> all() {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            File directory = new File(Resource.class.getClassLoader().getResource(this.pkg.replace(".", "/")).getFile());
            for (File file : directory.listFiles()) {
                resources.add(new Resource(this.pkg.replace(".", "/") + "/" + file.getName()));
            }
            return resources;
        }
    }
}

