/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.parallel;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.ftest.parallel.AbstractParallelTest;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import qualifier.Browser1;
import qualifier.Browser2;

public class TestGrapheneUtilitiesParalelly
extends AbstractParallelTest {
    @Browser1
    @FindBy(tagName="h1")
    private WebElement header1;
    @Browser2
    @FindBy(tagName="h1")
    private WebElement header2;
    @FindBy(tagName="h1")
    private WebElement headerDefault;
    @Page
    @Browser1
    private SimplePage page1;
    @Page
    @Browser2
    private SimplePage page2;
    @Page
    private SimplePage pageDefault;

    @Test
    public void testWaitWithElements() {
        Graphene.waitGui().until().element(this.header1).text().equalTo("Page 1");
        Graphene.waitGui().until().element(this.header2).text().equalTo("Page 2");
        Graphene.waitGui().until().element(this.headerDefault).text().equalTo("Page Default");
    }

    @Test
    public void testWaitWithBys() {
        Graphene.waitGui((WebDriver)this.browser1).until().element(By.tagName((String)"h1")).text().equalTo("Page 1");
        Graphene.waitGui((WebDriver)this.browser2).until().element(By.tagName((String)"h1")).text().equalTo("Page 2");
        Graphene.waitGui((WebDriver)this.browserDefault).until().element(By.tagName((String)"h1")).text().equalTo("Page Default");
    }

    @Test
    public void testGuardHttp() {
        this.checkGuardHttp(this.page1, this.page2, this.pageDefault);
    }

    @Test
    public void testMethodParamGuardHttp(@Page @Browser1 SimplePage paramPage1, @Page @Browser2 SimplePage paramPage2, @Page SimplePage paramPageDefault) {
        this.checkGuardHttp(paramPage1, paramPage2, paramPageDefault);
    }

    @Test
    public void testGuardXhr() {
        this.checkGuardXhr(this.page1, this.page2, this.pageDefault);
    }

    @Test
    public void testMethodParamGuardXhr(@Page @Browser1 SimplePage paramPage1, @Page @Browser2 SimplePage paramPage2, @Page SimplePage paramPageDefault) {
        this.checkGuardXhr(paramPage1, paramPage2, paramPageDefault);
    }

    public void checkGuardHttp(SimplePage checkPage1, SimplePage checkPage2, SimplePage checkPageDefault) {
        ((SimplePage)Graphene.guardHttp((Object)checkPage1)).http();
        ((SimplePage)Graphene.guardHttp((Object)checkPage2)).http();
        ((SimplePage)Graphene.guardHttp((Object)checkPageDefault)).http();
    }

    public void checkGuardXhr(SimplePage checkPage1, SimplePage checkPage2, SimplePage checkPageDefault) {
        ((SimplePage)Graphene.guardAjax((Object)checkPage1)).xhr();
        ((SimplePage)Graphene.guardAjax((Object)checkPage2)).xhr();
        ((SimplePage)Graphene.guardAjax((Object)checkPageDefault)).xhr();
    }

    public static class SimplePage {
        @FindBy
        private WebElement http;
        @FindBy
        private WebElement xhr;

        public void http() {
            this.http.click();
        }

        public void xhr() {
            this.xhr.click();
        }
    }
}

