/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest;

import com.sun.net.httpserver.HttpServer;
import java.net.InetSocketAddress;
import org.junit.rules.ExternalResource;

public class StubbedHttpServerRule
extends ExternalResource {
    private final int port;
    private HttpServer server;

    public StubbedHttpServerRule(int port) {
        this.port = port;
    }

    protected void before() throws Throwable {
        byte[] response = "Hello Drone!".getBytes();
        this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
        this.server.createContext("/", httpExchange -> {
            httpExchange.sendResponseHeaders(200, response.length);
            httpExchange.getResponseBody().write(response);
            httpExchange.close();
        });
        this.server.setExecutor(null);
        this.server.start();
    }

    protected void after() {
        this.server.stop(2);
    }

    public int getPort() {
        return this.port;
    }
}

