/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.proxy.GrapheneContextualHandler;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyUtil;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestEnrichedElementsEqualsMethod {
    @Drone
    private WebDriver browser;
    @ArquillianResource
    private URL contextRoot;
    @ArquillianResource
    private JavascriptExecutor executor;
    private static final String TEST_ELEMENT_ID = "select";
    @FindBy(id="select")
    private WebElement enriched;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("sample.html").loadPage(this.browser, this.contextRoot);
    }

    private WebElement getUnwrapped() {
        WebElement unwrapped = this.enriched;
        while (unwrapped instanceof WrapsElement) {
            unwrapped = ((WrapsElement)unwrapped).getWrappedElement();
        }
        if (unwrapped instanceof GrapheneElement || unwrapped instanceof GrapheneProxyInstance) {
            throw new RuntimeException("Not unwrapped enough: " + unwrapped.getClass());
        }
        return unwrapped;
    }

    private WebElement getProxified() {
        WebElement proxy;
        GrapheneContextualHandler handler = GrapheneContextualHandler.forTarget((GrapheneContext)GrapheneContext.lastContext(), (Object)this.browser);
        try {
            Method findElement = WebDriver.class.getMethod("findElement", By.class);
            proxy = (WebElement)handler.invoke((Object)this.browser, findElement, new Object[]{By.id((String)TEST_ELEMENT_ID)});
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (!(proxy instanceof GrapheneProxyInstance) || proxy instanceof GrapheneElement) {
            throw new RuntimeException("Not proxified correctly: " + Arrays.toString(GrapheneProxyUtil.getInterfaces((Class[])new Class[]{proxy.getClass()})));
        }
        return proxy;
    }

    @Test
    public void testEnrichedEqualsToSelf() {
        Assert.assertTrue((boolean)this.enriched.equals(this.enriched));
    }

    @Test
    public void testUnwrappedEqualsToSelf() {
        Assert.assertTrue((boolean)this.getUnwrapped().equals(this.getUnwrapped()));
    }

    @Test
    public void testProxifiedEqualsToSelf() {
        WebElement proxy = this.getProxified();
        Assert.assertTrue((boolean)proxy.equals(proxy));
    }

    @Test
    public void testProxifiedEqualsToProxified() {
        Assert.assertNotSame((Object)this.getProxified(), (Object)this.getProxified());
        Assert.assertTrue((boolean)this.getProxified().equals(this.getProxified()));
    }

    @Test
    public void testEnrichedEqualsToEnriched() {
        WebElement altEnriched = this.browser.findElement(By.id((String)TEST_ELEMENT_ID));
        Assert.assertNotSame((Object)this.enriched, (Object)altEnriched);
        Assert.assertNotSame((Object)((GrapheneProxyInstance)this.enriched).unwrap(), (Object)((GrapheneProxyInstance)altEnriched).unwrap());
        Assert.assertTrue((boolean)this.enriched.equals(altEnriched));
    }

    @Test
    public void testEnrichedEqualsToUnwrapped() {
        Assert.assertTrue((boolean)this.enriched.equals(this.getUnwrapped()));
    }

    @Test
    public void testEnrichedHashCodeEqualsToUnwrapped() {
        Assert.assertTrue((this.enriched.hashCode() == this.getUnwrapped().hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testUnwrappedEqualsToEnriched() {
        Assert.assertTrue((boolean)this.getUnwrapped().equals(this.enriched));
    }

    @Test
    public void testUnwrappedHashCodeEqualsToEnriched() {
        Assert.assertTrue((this.getUnwrapped().hashCode() == this.enriched.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEnrichedEqualsToProxified() {
        Assert.assertTrue((boolean)this.enriched.equals(this.getProxified()));
    }

    @Test
    public void testEnrichedHashCodeEqualsToProxified() {
        Assert.assertTrue((this.enriched.hashCode() == this.getProxified().hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testProxifiedEqualsToEnriched() {
        Assert.assertTrue((boolean)this.getProxified().equals(this.enriched));
    }

    @Test
    public void testProxifiedHashCodeEqualsToEnriched() {
        Assert.assertTrue((this.getProxified().hashCode() == this.enriched.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testUnwrappedEqualsToProxified() {
        Assert.assertTrue((boolean)this.getUnwrapped().equals(this.getProxified()));
    }

    @Test
    public void testUnwrappedHashCodeEqualsToProxified() {
        Assert.assertTrue((this.getUnwrapped().hashCode() == this.getProxified().hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testProxifiedEqualsToUnwrapped() {
        Assert.assertTrue((boolean)this.getProxified().equals(this.getUnwrapped()));
    }

    @Test
    public void testProxifiedHashCodeEqualsToUnwrapped() {
        Assert.assertTrue((this.getProxified().hashCode() == this.getUnwrapped().hashCode() ? 1 : 0) != 0);
    }

    private WebElement getReturnedFromJSExecutor() {
        return (WebElement)this.executor.executeScript("return document.getElementById('select')", new Object[0]);
    }

    @Test
    public void testEnrichedEqualsToReturnedFromJSExecutor() {
        Assert.assertTrue((boolean)this.enriched.equals(this.getReturnedFromJSExecutor()));
    }

    @Test
    public void testReturnedFromJSExecutorEqualsToEnriched() {
        Assert.assertTrue((boolean)this.getReturnedFromJSExecutor().equals(this.enriched));
    }

    private WebElement getTargetActiveElement() {
        this.enriched.click();
        return this.browser.switchTo().activeElement();
    }

    @Test
    public void testEnrichedEqualsToTargetActiveElement() {
        Assert.assertTrue((boolean)this.enriched.equals(this.getTargetActiveElement()));
    }

    @Test
    public void testTargetActiveElementEqualsToEnriched() {
        Assert.assertTrue((boolean)this.getTargetActiveElement().equals(this.enriched));
    }
}

