/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.net.URL;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestHandlingOfStaleElements {
    @Drone
    private WebDriver browser;
    @ArquillianResource
    private JavascriptExecutor executor;
    @FindBy(id="root")
    private StaleElementPageFragment pageFragment;
    @FindBy(id="stale")
    private StaleRootPageFragment rootPageFragment;
    @FindBy(id="root")
    private List<StaleElementPageFragment> pageFragments;
    @FindBy(id="root")
    private WebElement rootElement;
    @FindBy(id="stale")
    private WebElement staleElement;
    @FindBy(id="root")
    private List<WebElement> rootElements;
    @FindBy(tagName="body")
    private WebElement body;
    @ArquillianResource
    private URL contextRoot;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("staleelements.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void testDeletion() {
        this.rootElement.isDisplayed();
        try {
            this.executor.executeScript("return arguments[0].parentNode.removeChild(arguments[0])", new Object[]{this.rootElement});
            this.rootElement.isDisplayed();
            Assert.fail((String)"rootElement should not be found");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testReplacement() {
        this.rootElement.isDisplayed();
        try {
            this.executor.executeScript("return arguments[1].parentNode.replaceChild(arguments[0],arguments[1])", new Object[]{this.staleElement, this.rootElement});
            this.rootElement.isDisplayed();
            Assert.fail((String)"rootElement should not be found");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.staleElement.isDisplayed();
    }

    @Test
    public void testElement() throws Exception {
        this.rootElement.isDisplayed();
        this.pageFragment.makeStale();
        this.rootElement.isDisplayed();
    }

    @Test
    public void testListOfElements() throws Exception {
        WebElement e = this.rootElements.get(0);
        e.isDisplayed();
        this.pageFragment.makeStale();
        e.isDisplayed();
    }

    @Test
    public void testPageFragment() throws Exception {
        this.pageFragment.getRoot().isDisplayed();
        this.pageFragment.makeStale();
        this.pageFragment.getRoot().isDisplayed();
    }

    @Test
    public void testPageFragmentWithStaleRoot() {
        this.rootPageFragment.getInStale().isDisplayed();
        this.pageFragment.makeStale();
        this.rootPageFragment.getInStale().isDisplayed();
    }

    @Test
    public void testListOfPageFragments() throws Exception {
        StaleElementPageFragment pf = this.pageFragments.get(0);
        pf.getRoot().isDisplayed();
        pf.makeStale();
        pf.getRoot().isDisplayed();
    }

    public static class StaleRootPageFragment {
        @FindBy(className="in-stale")
        private WebElement inStale;

        public WebElement getInStale() {
            return this.inStale;
        }
    }

    public static class StaleElementPageFragment {
        @Root
        private WebElement root;
        @FindBy(className="make-stale")
        private WebElement makeStale;

        public void makeStale() {
            this.makeStale.click();
        }

        public WebElement getRoot() {
            return this.root;
        }
    }
}

