/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.wait;

import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.wait.AttributeBuilder;
import org.jboss.arquillian.graphene.wait.ElementBuilder;
import org.jboss.arquillian.graphene.wait.IsAttributeBuilder;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.jboss.arquillian.junit.ArquillianTest;
import org.jboss.arquillian.junit.ArquillianTestClass;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;

@RunAsClient
public abstract class AbstractWaitJUnitRulesTest {
    @ClassRule
    public static ArquillianTestClass arquillianTestClass = new ArquillianTestClass();
    @Rule
    public ArquillianTest arquillianTest = new ArquillianTest();
    @Drone
    protected WebDriver browser;
    @ArquillianResource
    private URL contextRoot;
    protected static final By BY_HEADER = By.id((String)"header");
    protected static final By BY_OPTION1 = By.id((String)"option1");
    protected static final By BY_SELECT = By.id((String)"select");
    protected static final By BY_TEXT_INPUT = By.id((String)"textInput");
    protected static final By BY_INPUT_WITH_EMPTY_STYLE = By.id((String)"inputWithEmptyStyle");
    protected static final By BY_INPUT_WITH_EMPTY_STYLE_WHITE_SPACES = By.id((String)"inputWithEmptyStyleWhiteSpaces");
    protected static final By BY_INPUT_WITH_NO_STYLE_DEFINED = By.id((String)"inputWithNoStyleDefined");
    protected static final By BY_INPUT_WITH_EMPTY_READONLY = By.id((String)"inputWithEmptyReadonly");
    @FindBy(id="appear")
    protected WebElement appearButton;
    @FindBy(id="header")
    protected WebElement header;
    @FindBy(id="hide")
    protected WebElement hideButton;
    @FindBy(id="idInput")
    protected WebElement idInput;
    @FindBy(id="option1")
    protected WebElement option1;
    @FindBy(id="select")
    protected WebElement select;
    @FindBy(id="textInput")
    protected WebElement textInput;
    @FindBy(id="submit")
    protected WebElement updateButton;
    @FindBy
    protected WebElement enableSelect;
    @FindBy
    protected WebElement disableSelect;
    @FindBy
    protected WebElement inputWithEmptyStyle;
    @FindBy
    protected WebElement inputWithEmptyStyleWhiteSpaces;
    @FindBy
    protected WebElement inputWithNoStyleDefined;
    @FindBy
    protected WebElement inputWithEmptyReadonly;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("sample.html").loadPage(this.browser, this.contextRoot);
    }

    protected void checkAttributeIsPresent(AttributeBuilder<?> headerStyle) {
        this.hideButton.click();
        headerStyle.is().present();
        this.appearButton.click();
        ((IsAttributeBuilder)headerStyle.is().not()).present();
    }

    protected void checkAttributeValueContains(AttributeBuilder<?> textInputValue) {
        this.textInput.clear();
        ((StringMatcher)textInputValue.not()).contains("Tested");
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        textInputValue.contains("Tested");
    }

    protected void checkAttributeValueEquals(AttributeBuilder<?> textInputValue) {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"Tested"});
        ((StringMatcher)textInputValue.not()).equalTo("Tested Header");
        this.textInput.sendKeys(new CharSequence[]{" Header"});
        textInputValue.equalTo("Tested Header");
    }

    protected void checkElementIsPresent(ElementBuilder<?> header) {
        this.idInput.clear();
        this.idInput.sendKeys(new CharSequence[]{"header2"});
        this.updateButton.click();
        ((IsElementBuilder)header.is().not()).present();
        this.idInput.clear();
        this.idInput.sendKeys(new CharSequence[]{"header"});
        this.updateButton.click();
        header.is().present();
    }

    protected void checkElementIsSelected(ElementBuilder<?> option1) {
        new Select(this.select).selectByIndex(0);
        option1.is().selected();
        new Select(this.select).selectByIndex(1);
        ((IsElementBuilder)option1.is().not()).selected();
    }

    protected void checkElementTextContains(ElementBuilder<?> header) {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        header.text().contains("machine");
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        ((StringMatcher)header.text().not()).contains("machine");
    }

    protected void checkElementTextEquals(ElementBuilder<?> header) {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        header.text().equalTo("florence and the machine");
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        ((StringMatcher)header.text().not()).equalTo("florence and the machine");
    }

    protected void checkElementIsVisible(ElementBuilder<?> header) {
        this.hideButton.click();
        ((IsElementBuilder)header.is().not()).visible();
        this.appearButton.click();
        header.is().visible();
    }

    protected void checkElementIsEnabled(ElementBuilder<?> select) {
        this.disableSelect.click();
        ((IsElementBuilder)select.is().not()).enabled();
        this.enableSelect.click();
        select.is().enabled();
    }
}

