/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.wait;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.ftest.wait.AbstractWaitTest;
import org.jboss.arquillian.graphene.wait.IsAttributeBuilder;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class SearchContextLocatorAttributeTest
extends AbstractWaitTest {
    protected static final By BY_CLASS_HEADER = By.className((String)"header");
    protected static final By BY_CLASS_OPTION1 = By.className((String)"option1");
    protected static final By BY_CLASS_SELECT = By.className((String)"select");
    protected static final By BY_CLASS_TEXT_INPUT = By.className((String)"textInput");
    protected static final By BY_CLASS_INPUT_WITH_EMPTY_STYLE = By.className((String)"inputWithEmptyStyle");
    protected static final By BY_CLASS_INPUT_WITH_EMPTY_STYLE_WHITE_SPACES = By.className((String)"inputWithEmptyStyleWhiteSpaces");
    protected static final By BY_CLASS_INPUT_WITH_NO_STYLE_DEFINED = By.className((String)"inputWithNoStyleDefined");
    protected static final By BY_CLASS_INPUT_WITH_EMPTY_READONLY = By.className((String)"inputWithEmptyReadonly");
    @FindBy(id="correct")
    private WebElement correct;

    @Test
    public void testAttributeIsPresent() {
        this.checkAttributeIsPresent(Graphene.waitAjax().until().element((SearchContext)this.correct, BY_CLASS_HEADER).attribute("style"));
    }

    @Test
    public void testAttributeIsPresentDirectly() {
        this.hideButton.click();
        Graphene.waitModel().until().element((SearchContext)this.correct, BY_CLASS_HEADER).attribute("style").is().present();
        this.appearButton.click();
        ((IsAttributeBuilder)Graphene.waitModel().until().element((SearchContext)this.correct, BY_CLASS_HEADER).attribute("style").is().not()).present();
    }

    @Test
    public void testAttributeValueContains() {
        this.checkAttributeValueContains(Graphene.waitModel().until().element((SearchContext)this.correct, BY_CLASS_TEXT_INPUT).attribute("value"));
    }

    @Test
    public void testAttributeValueEquals() {
        this.checkAttributeValueEquals(Graphene.waitModel().until().element((SearchContext)this.correct, BY_CLASS_TEXT_INPUT).attribute("value"));
    }

    @Test
    public void testEmptyAttribute() {
        ((IsAttributeBuilder)Graphene.waitModel().until().element((SearchContext)this.correct, BY_CLASS_INPUT_WITH_EMPTY_STYLE).attribute("style").is().not()).present();
        ((IsAttributeBuilder)Graphene.waitModel().until().element((SearchContext)this.correct, BY_CLASS_INPUT_WITH_NO_STYLE_DEFINED).attribute("style").is().not()).present();
        ((IsAttributeBuilder)Graphene.waitModel().until().element((SearchContext)this.correct, BY_CLASS_INPUT_WITH_EMPTY_STYLE_WHITE_SPACES).attribute("style").is().not()).present();
        Graphene.waitModel().until().element((SearchContext)this.correct, BY_CLASS_INPUT_WITH_EMPTY_READONLY).attribute("readonly").is().present();
    }

    @Test
    public void testValueContains() {
        this.loadPage();
        this.checkAttributeValueContains(Graphene.waitModel().until().element((SearchContext)this.correct, BY_CLASS_TEXT_INPUT).value());
    }

    @Test
    public void testValueEquals() {
        this.loadPage();
        this.checkAttributeValueEquals(Graphene.waitModel().until().element((SearchContext)this.correct, BY_CLASS_TEXT_INPUT).value());
    }
}

