/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.context;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import net.sf.cglib.proxy.Callback;
import org.jboss.arquillian.graphene.context.ClassImposterizer;
import org.jboss.arquillian.graphene.context.GrapheneProxyHandler;
import org.jboss.arquillian.graphene.context.GrapheneProxyInstance;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrapheneProxy {
    public static boolean isProxyInstance(WebDriver driver) {
        return driver instanceof GrapheneProxyInstance;
    }

    static <T> T getProxyForTarget(T target) {
        GrapheneProxyHandler handler = GrapheneProxyHandler.forTarget(target);
        return GrapheneProxy.createProxy(handler, target.getClass(), new Class[0]);
    }

    static <T> T getProxyForTargetWithInterfaces(T target, Class<?> ... interfaces) {
        GrapheneProxyHandler handler = GrapheneProxyHandler.forTarget(target);
        return GrapheneProxy.createProxy(handler, null, interfaces);
    }

    static <T> T getProxyForFutureTarget(FutureTarget futureTarget, Class<?> baseType, Class<?> ... additionalInterfaces) {
        GrapheneProxyHandler handler = GrapheneProxyHandler.forFuture(futureTarget);
        return GrapheneProxy.createProxy(handler, baseType, additionalInterfaces);
    }

    static <T> T createProxy(GrapheneProxyHandler interceptor, Class<?> baseType, Class<?> ... additionalInterfaces) {
        Class<?>[] ancillaryTypes = GrapheneProxy.concat(additionalInterfaces, GrapheneProxyInstance.class);
        if (baseType == null || baseType.isInterface()) {
            if (baseType != null) {
                ancillaryTypes = GrapheneProxy.concat(ancillaryTypes, baseType);
            }
            return (T)Proxy.newProxyInstance(GrapheneProxy.class.getClassLoader(), ancillaryTypes, (InvocationHandler)interceptor);
        }
        return (T)ClassImposterizer.INSTANCE.imposterise((Callback)interceptor, baseType, ancillaryTypes);
    }

    private static Class<?>[] concat(Class<?>[] interfaces, Class<?> clazz) {
        int length = interfaces.length;
        Class[] out = new Class[length + 1];
        System.arraycopy(interfaces, 0, out, 0, length);
        out[length] = clazz;
        return out;
    }

    static interface FutureTarget {
        public Object getTarget();
    }
}

