/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.context;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.jboss.arquillian.graphene.context.GrapheneProxy;
import org.jboss.arquillian.graphene.context.GrapheneProxyUtil;

class GrapheneProxyHandler
implements MethodInterceptor,
InvocationHandler {
    private Object target;
    private GrapheneProxy.FutureTarget future;

    private GrapheneProxyHandler() {
    }

    static GrapheneProxyHandler forTarget(Object target) {
        GrapheneProxyHandler handler = new GrapheneProxyHandler();
        handler.target = target;
        return handler;
    }

    static GrapheneProxyHandler forFuture(GrapheneProxy.FutureTarget future) {
        GrapheneProxyHandler handler = new GrapheneProxyHandler();
        handler.future = future;
        return handler;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = this.invokeReal(method, args);
        if (this.isProxyable(method, args)) {
            Class<?>[] interfaces = GrapheneProxyUtil.getInterfaces(result.getClass());
            return GrapheneProxy.getProxyForTargetWithInterfaces(result, interfaces);
        }
        return result;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        return this.invoke(proxy, method, args);
    }

    boolean isProxyable(Method method, Object[] args) {
        Class<?> returnType = method.getReturnType();
        return returnType.isInterface();
    }

    Object invokeReal(Method method, Object[] args) throws Throwable {
        Object result;
        Object target = this.getTarget();
        try {
            result = method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected invocation exception: " + e.getMessage(), e);
        }
        return result;
    }

    Object getTarget() {
        return this.future == null ? this.target : this.future.getTarget();
    }
}

