/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.context;

import org.jboss.arquillian.graphene.page.extension.PageExtensionInstallatorProvider;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistry;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;

public class GraphenePageExtensionsContext {
    private static final ThreadLocal<PageExtensionRegistry> REGISTRY_REFERENCE = new ThreadLocal();
    private static final ThreadLocal<PageExtensionInstallatorProvider> INSTALLATOR_PROVIDER_REFERENCE = new ThreadLocal();
    private static GrapheneProxy.FutureTarget INSTALLATOR_PROVIDER_TARGET = new GrapheneProxy.FutureTarget(){

        public Object getTarget() {
            return GraphenePageExtensionsContext.getInstallatorProvider();
        }
    };
    private static GrapheneProxy.FutureTarget REGISTRY_TARGET = new GrapheneProxy.FutureTarget(){

        public Object getTarget() {
            return GraphenePageExtensionsContext.getRegistry();
        }
    };

    public static PageExtensionRegistry getRegistryProxy() {
        return (PageExtensionRegistry)GrapheneProxy.getProxyForFutureTarget(REGISTRY_TARGET, PageExtensionRegistry.class, new Class[0]);
    }

    public static PageExtensionInstallatorProvider getInstallatorProviderProxy() {
        return (PageExtensionInstallatorProvider)GrapheneProxy.getProxyForFutureTarget(INSTALLATOR_PROVIDER_TARGET, PageExtensionInstallatorProvider.class, new Class[0]);
    }

    public static boolean isInitialized() {
        return REGISTRY_REFERENCE.get() != null && INSTALLATOR_PROVIDER_REFERENCE != null;
    }

    public static void reset() {
        REGISTRY_REFERENCE.set(null);
        INSTALLATOR_PROVIDER_REFERENCE.set(null);
    }

    public static void setInstallatorProvider(PageExtensionInstallatorProvider installatorProvider) {
        if (installatorProvider == null) {
            throw new IllegalArgumentException("context instance can't be null");
        }
        if (GrapheneProxy.isProxyInstance(installatorProvider)) {
            throw new IllegalArgumentException("instance of the proxy can't be set to the context");
        }
        INSTALLATOR_PROVIDER_REFERENCE.set(installatorProvider);
    }

    public static void setRegistry(PageExtensionRegistry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("context instance can't be null");
        }
        if (GrapheneProxy.isProxyInstance(registry)) {
            throw new IllegalArgumentException("instance of the proxy can't be set to the context");
        }
        REGISTRY_REFERENCE.set(registry);
    }

    static PageExtensionInstallatorProvider getInstallatorProvider() {
        PageExtensionInstallatorProvider installatorProvider = INSTALLATOR_PROVIDER_REFERENCE.get();
        if (installatorProvider == null) {
            throw new NullPointerException("context is null - it needs to be setup before starting to use it");
        }
        return installatorProvider;
    }

    static PageExtensionRegistry getRegistry() {
        PageExtensionRegistry registry = REGISTRY_REFERENCE.get();
        if (registry == null) {
            throw new NullPointerException("context is null - it needs to be setup before starting to use it");
        }
        return registry;
    }
}

