/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.javascript;

import java.lang.reflect.Method;
import org.jboss.arquillian.graphene.javascript.JSTarget;
import org.jboss.arquillian.graphene.javascript.MethodName;

public class JSMethod {
    private JSTarget target;
    private Method method;
    private String name;

    public JSMethod(JSTarget target, Method method) {
        this.target = target;
        this.method = method;
        this.name = this.resolveName(method);
    }

    public JSTarget getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    private String resolveName(Method method) {
        MethodName annotation = method.getAnnotation(MethodName.class);
        if (annotation != null && !"".equals(annotation.value())) {
            return annotation.value();
        }
        return method.getName();
    }

    public String toString() {
        return "JSMethod [method=" + this.method.getName() + ", name=" + this.name + ", target=" + this.target + "]";
    }
}

