/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyUtil;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.jboss.arquillian.graphene.proxy.InvocationContextImpl;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.MethodInterceptor;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.MethodProxy;

class GrapheneProxyHandler
implements MethodInterceptor,
InvocationHandler {
    private Object target;
    private GrapheneProxy.FutureTarget future;
    private Map<Class<?>, Interceptor> interceptors = new HashMap();

    private GrapheneProxyHandler() {
    }

    static GrapheneProxyHandler forTarget(Object target) {
        GrapheneProxyHandler handler = new GrapheneProxyHandler();
        handler.target = target;
        return handler;
    }

    static GrapheneProxyHandler forFuture(GrapheneProxy.FutureTarget future) {
        GrapheneProxyHandler handler = new GrapheneProxyHandler();
        handler.future = future;
        return handler;
    }

    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        if (method.equals(GrapheneProxyInstance.class.getMethod("unwrap", new Class[0]))) {
            Object target = this.getTarget();
            if (target instanceof GrapheneProxyInstance) {
                return ((GrapheneProxyInstance)target).unwrap();
            }
            return target;
        }
        if (method.equals(GrapheneProxyInstance.class.getMethod("registerInterceptor", Interceptor.class))) {
            Interceptor interceptor = (Interceptor)args[0];
            if (interceptor == null) {
                throw new IllegalArgumentException("The parameter [interceptor] is null.");
            }
            this.interceptors.put(interceptor.getClass(), interceptor);
            return null;
        }
        if (method.equals(GrapheneProxyInstance.class.getMethod("unregisterInterceptor", Interceptor.class))) {
            Interceptor interceptor = (Interceptor)args[0];
            if (interceptor == null) {
                throw new IllegalArgumentException("The parameter [interceptor] is null.");
            }
            return this.interceptors.remove(interceptor.getClass());
        }
        if (method.equals(GrapheneProxyInstance.class.getMethod("copy", new Class[0]))) {
            GrapheneProxyInstance clone = this.future != null ? (GrapheneProxyInstance)GrapheneProxy.getProxyForFutureTarget(this.future, this.future.getTarget().getClass(), this.future.getTarget().getClass().getInterfaces()) : (GrapheneProxyInstance)GrapheneProxy.getProxyForTarget(this.target);
            for (Interceptor interceptor : this.interceptors.values()) {
                clone.registerInterceptor(interceptor);
            }
            return clone;
        }
        InvocationContext invocationContext = new InvocationContext(){

            public Object invoke() throws Throwable {
                Object result = GrapheneProxyHandler.this.invokeReal(this.getTarget(), method, args);
                if (result == null) {
                    return null;
                }
                if (GrapheneProxyHandler.this.isProxyable(method, args)) {
                    Class<?>[] interfaces = GrapheneProxyUtil.getInterfaces(result.getClass());
                    return GrapheneProxy.getProxyForTargetWithInterfaces(result, interfaces);
                }
                return result;
            }

            public Method getMethod() {
                return method;
            }

            public Object[] getArguments() {
                return args;
            }

            public Object getTarget() {
                return GrapheneProxyHandler.this.getTarget();
            }
        };
        for (Interceptor interceptor : this.interceptors.values()) {
            invocationContext = new InvocationContextImpl(interceptor, invocationContext);
        }
        return invocationContext.invoke();
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        return this.invoke(proxy, method, args);
    }

    boolean isProxyable(Method method, Object[] args) {
        Class<?> returnType = method.getReturnType();
        return returnType.isInterface();
    }

    Object invokeReal(Object target, Method method, Object[] args) throws Throwable {
        Object result;
        try {
            if (target instanceof GrapheneProxyInstance) {
                target = ((GrapheneProxyInstance)target).unwrap();
            }
            result = method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected invocation exception during invocation of " + method.getDeclaringClass().getName() + "#" + method.getName() + "(), on target '" + target.getClass().getName() + "': " + e.getMessage(), e);
        }
        return result;
    }

    Object getTarget() {
        return this.future == null ? this.target : this.future.getTarget();
    }
}

