/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.context;

import org.jboss.arquillian.graphene.configuration.GrapheneConfiguration;
import org.jboss.arquillian.graphene.context.GrapheneConfigurationContext;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.context.TestingDriverStub;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@RunWith(value=MockitoJUnitRunner.class)
public class TestGrapheneContextProxying {
    private static final String SAMPLE_STRING = "sample";
    @Mock
    WebDriver driver;

    @Test
    public void context_provides_proxy_which_delegates_to_current_context() {
        DriverReturningSampleString driver = new DriverReturningSampleString();
        GrapheneContext.set((WebDriver)driver);
        GrapheneConfigurationContext.set((GrapheneConfiguration)new GrapheneConfiguration());
        WebDriver proxy = GrapheneContext.getProxy();
        Assert.assertEquals((Object)SAMPLE_STRING, (Object)proxy.toString());
    }

    @Test
    public void when_proxy_returns_webdriver_api_then_another_proxy_is_returned_wrapping_the_result_of_invocation() {
        WebDriver.Navigation navigation = (WebDriver.Navigation)Mockito.mock(WebDriver.Navigation.class);
        GrapheneContext.set((WebDriver)this.driver);
        GrapheneConfigurationContext.set((GrapheneConfiguration)new GrapheneConfiguration());
        Mockito.when((Object)this.driver.navigate()).thenReturn((Object)navigation);
        WebDriver driverProxy = GrapheneContext.getProxy();
        WebDriver.Navigation navigationProxy = driverProxy.navigate();
        Assert.assertTrue((boolean)(navigationProxy instanceof GrapheneProxyInstance));
        ((WebDriver)Mockito.verify((Object)this.driver, (VerificationMode)Mockito.only())).navigate();
    }

    @Test
    public void when_proxy_returns_result_of_invocation_with_arguments_then_returned_object_is_proxied() {
        WebElement webElement = (WebElement)Mockito.mock(WebElement.class);
        By byId = By.id((String)"id");
        GrapheneContext.set((WebDriver)this.driver);
        GrapheneConfigurationContext.set((GrapheneConfiguration)new GrapheneConfiguration());
        Mockito.when((Object)this.driver.findElement(byId)).thenReturn((Object)webElement);
        WebDriver driverProxy = GrapheneContext.getProxy();
        WebElement webElementProxy = driverProxy.findElement(byId);
        webElementProxy.clear();
        Assert.assertTrue((boolean)(webElementProxy instanceof GrapheneProxyInstance));
        ((WebDriver)Mockito.verify((Object)this.driver, (VerificationMode)Mockito.atLeastOnce())).findElement(byId);
    }

    @Test
    public void when_proxy_returns_result_of_invocation_with_arguments_then_returned_object_can_be_invoked() {
        WebElement webElement = (WebElement)Mockito.mock(WebElement.class);
        By byId = By.id((String)"id");
        GrapheneContext.set((WebDriver)this.driver);
        GrapheneConfigurationContext.set((GrapheneConfiguration)new GrapheneConfiguration());
        Mockito.when((Object)this.driver.findElement(byId)).thenReturn((Object)webElement);
        WebDriver driverProxy = GrapheneContext.getProxy();
        WebElement webElementProxy = driverProxy.findElement(byId);
        webElementProxy.clear();
        ((WebElement)Mockito.verify((Object)webElement, (VerificationMode)Mockito.only())).clear();
    }

    @Test
    public void test_that_context_can_be_unwrapped() {
        GrapheneContext.set((WebDriver)this.driver);
        GrapheneConfigurationContext.set((GrapheneConfiguration)new GrapheneConfiguration());
        WebDriver driverProxy = GrapheneContext.getProxy();
        WebDriver unwrapped = (WebDriver)((GrapheneProxyInstance)driverProxy).unwrap();
        Assert.assertSame((Object)this.driver, (Object)unwrapped);
    }

    private static class DriverReturningSampleString
    extends TestingDriverStub {
        private DriverReturningSampleString() {
        }

        public String toString() {
            return TestGrapheneContextProxying.SAMPLE_STRING;
        }
    }
}

