/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.intercept;

import org.jboss.arquillian.graphene.intercept.InterceptorBuilder;
import org.jboss.arquillian.graphene.intercept.Interceptors;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

@RunWith(value=MockitoJUnitRunner.class)
public class TestInterceptorBuilder {
    @Mock
    WebDriver driver;
    @Mock
    Interceptor interceptor1;
    @Mock
    Interceptor interceptor2;
    @Mock
    By by;

    @Before
    public void before() throws Throwable {
        Answer<Object> invoke = new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return ((InvocationContext)invocation.getArguments()[0]).invoke();
            }
        };
        Mockito.when((Object)this.interceptor1.intercept((InvocationContext)Mockito.any(InvocationContext.class))).thenAnswer((Answer)invoke);
        Mockito.when((Object)this.interceptor2.intercept((InvocationContext)Mockito.any(InvocationContext.class))).thenAnswer((Answer)invoke);
    }

    @Test
    public void test() throws Throwable {
        InterceptorBuilder builder = new InterceptorBuilder();
        ((WebDriver)builder.interceptInvocation(WebDriver.class, this.interceptor1)).findElement((By)Interceptors.any(By.class));
        ((WebDriver)builder.interceptInvocation(WebDriver.class, this.interceptor2)).findElement((By)Interceptors.any(By.class));
        Interceptor builtInterceptor = builder.build();
        WebDriver driverProxy = (WebDriver)GrapheneProxy.getProxyForTargetWithInterfaces((Object)this.driver, (Class[])new Class[]{WebDriver.class});
        GrapheneProxyInstance proxy = (GrapheneProxyInstance)driverProxy;
        proxy.registerInterceptor(builtInterceptor);
        driverProxy.findElement(this.by);
        Mockito.inOrder((Object[])new Object[]{this.interceptor1, this.interceptor2});
        ((Interceptor)Mockito.verify((Object)this.interceptor1)).intercept((InvocationContext)Mockito.any(InvocationContext.class));
        ((Interceptor)Mockito.verify((Object)this.interceptor2)).intercept((InvocationContext)Mockito.any(InvocationContext.class));
    }
}

