/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.proxy.ClassImposterizer;
import org.jboss.arquillian.graphene.proxy.GrapheneContextualHandler;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyHandler;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyUtil;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.Enhancer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrapheneProxy {
    public static boolean isProxyInstance(Object target) {
        return target instanceof GrapheneProxyInstance;
    }

    public static <T> T getProxyForTarget(GrapheneContext context, T target) {
        if (Modifier.isFinal(target.getClass().getModifiers())) {
            if (target.getClass().getInterfaces().length > 0) {
                return GrapheneProxy.getProxyForTargetWithInterfaces(context, target, target.getClass().getInterfaces());
            }
            throw new IllegalStateException("Can't create a proxy for " + target.getClass() + ", it's final and id doesn't implement any interface.");
        }
        GrapheneContextualHandler handler = GrapheneContextualHandler.forTarget(context, target);
        return (T)GrapheneProxy.createProxy(handler, target.getClass(), new Class[0]);
    }

    public static <T> T getProxyForTargetWithInterfaces(GrapheneContext context, T target, Class<?> ... interfaces) {
        GrapheneContextualHandler handler = GrapheneContextualHandler.forTarget(context, target);
        return GrapheneProxy.createProxy(handler, null, interfaces);
    }

    @Deprecated
    public static <T> T getProxyForFutureTarget(GrapheneContext context, FutureTarget futureTarget, Class<?> baseType, Class<?> ... additionalInterfaces) {
        if (baseType != null && !baseType.isInterface() && Modifier.isFinal(baseType.getModifiers())) {
            if (additionalInterfaces.length > 0) {
                return GrapheneProxy.getProxyForFutureTarget(context, futureTarget, additionalInterfaces[0], additionalInterfaces);
            }
            throw new IllegalStateException("Can't create a proxy for " + baseType + ", it's final and no additional interface has been given.");
        }
        GrapheneContextualHandler handler = GrapheneContextualHandler.forFuture(context, futureTarget);
        return GrapheneProxy.getProxyForHandler(handler, baseType, additionalInterfaces);
    }

    public static <T> T getProxyForHandler(GrapheneProxyHandler handler, Class<?> baseType, Class<?> ... additionalInterfaces) {
        return (T)GrapheneProxy.createProxy(handler, baseType, additionalInterfaces);
    }

    static <T> T createProxy(GrapheneProxyHandler interceptor, Class<T> baseType, Class<?> ... additionalInterfaces) {
        Object result;
        if (baseType != null) {
            while (Enhancer.isEnhanced(baseType)) {
                baseType = baseType.getSuperclass();
            }
        }
        Class<?>[] ancillaryTypes = GrapheneProxyUtil.concatClasses(additionalInterfaces, GrapheneProxyInstance.class);
        if (baseType == null || baseType.isInterface()) {
            if (baseType != null) {
                ancillaryTypes = GrapheneProxyUtil.concatClasses(ancillaryTypes, baseType);
            }
            result = Proxy.newProxyInstance(GrapheneProxy.class.getClassLoader(), ancillaryTypes, (InvocationHandler)interceptor);
        } else {
            result = ClassImposterizer.INSTANCE.imposterise(interceptor, baseType, ancillaryTypes);
        }
        return (T)result;
    }

    public static class ConstantFutureTarget
    implements FutureTarget {
        private final Object target;

        public ConstantFutureTarget(Object target) {
            this.target = target;
        }

        public Object getTarget() {
            return this.target;
        }
    }

    public static interface FutureTarget {
        public Object getTarget();
    }
}

