/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import junit.framework.Assert;
import org.jboss.arquillian.graphene.enricher.AbstractGrapheneEnricherTest;
import org.jboss.arquillian.graphene.enricher.exception.PageFragmentInitializationException;
import org.jboss.arquillian.graphene.enricher.fragment.WrongPageFragmentMissingNoArgConstructor;
import org.jboss.arquillian.graphene.enricher.fragment.WrongPageFragmentTooManyRoots;
import org.junit.Test;
import org.openqa.selenium.support.FindBy;

public class TestPageFragmentEnricher
extends AbstractGrapheneEnricherTest {
    @Test
    public void testMissingNoArgConstructor() {
        NoArgConstructorTest target = new NoArgConstructorTest();
        this.getGrapheneEnricher().enrich((Object)target);
        Assert.assertNull((Object)target.pageFragment);
    }

    @Test
    public void testTooManyRoots() {
        this.thrown.expect(PageFragmentInitializationException.class);
        this.getGrapheneEnricher().enrich((Object)new TooManyRootsTest());
    }

    @Test(expected=PageFragmentInitializationException.class)
    public void testAbstractType() {
        AbstractTypeTest target = new AbstractTypeTest();
        this.getGrapheneEnricher().enrich((Object)target);
        Assert.assertNotNull((Object)target.pageFragment);
    }

    public abstract class AbstractType {
    }

    public static class AbstractTypeTest {
        @FindBy(id="foo")
        private AbstractType pageFragment;
    }

    public static class TooManyRootsTest {
        @FindBy(id="foo")
        private WrongPageFragmentTooManyRoots pageFragment;
    }

    public static class NoArgConstructorTest {
        @FindBy(id="blah")
        private WrongPageFragmentMissingNoArgConstructor pageFragment;
    }
}

