/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.proxy;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.arquillian.graphene.TestingDriver;
import org.jboss.arquillian.graphene.TestingDriverStub;
import org.jboss.arquillian.graphene.TestingDriverStubExtension;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyUtil;
import org.junit.Assert;
import org.junit.Test;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestGrapheneProxyUtil {
    @Test
    public void test_getInterface_with_WebDriver() {
        Set<Class<?>> actual = this.actual(WebDriver.class);
        Set<Class<?>> expected = this.expected(WebDriver.class, SearchContext.class);
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void test_getInterface_with_interface_which_extends_another_interfaces() {
        Set<Class<?>> actual = this.actual(TestingDriver.class);
        Set<Class<?>> expected = this.expected(TestingDriver.INTERFACES, (Class<?>[])new Class[]{TestingDriver.class});
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void test_getInterfaces_with_class_which_implements_wanted_interface() {
        Set<Class<?>> actual = this.actual(TestingDriverStub.class);
        Set<Class<?>> expected = this.expected(TestingDriver.class);
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void test_getInterfaces_with_class_extending_class_which_implements_wanted_interface() {
        Set<Class<?>> actual = this.actual(TestingDriverStubExtension.class);
        Set<Class<?>> expected = this.expected(TestingDriver.class);
        Assert.assertEquals(expected, actual);
    }

    private Set<Class<?>> actual(Class<?> ... classes) {
        return new HashSet(Arrays.asList(GrapheneProxyUtil.getInterfaces((Class[])classes)));
    }

    private Set<Class<?>> expected(Class<?> ... classes) {
        return new HashSet(Arrays.asList(classes));
    }

    private Set<Class<?>> expected(Class<?>[] classes1, Class<?> ... classes2) {
        HashSet set = new HashSet(Arrays.asList(classes1));
        set.addAll(Arrays.asList(classes2));
        return set;
    }
}

