/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.javascript;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.javascript.JSCall;
import org.jboss.arquillian.graphene.javascript.JSInterface;
import org.jboss.arquillian.graphene.javascript.JSMethod;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.MethodInterceptor;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.MethodProxy;

public class JSInterfaceHandler
implements MethodInterceptor {
    private final JSInterface target;
    private final GrapheneContext context;

    public JSInterfaceHandler(JSInterface target, GrapheneContext context) {
        this.target = target;
        this.context = context;
    }

    public JSInterface getTarget() {
        return this.target;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        if (!this.target.getInterface().isInterface() && !Modifier.isAbstract(method.getModifiers())) {
            return methodProxy.invokeSuper(obj, args);
        }
        if (method.getName().equals("finalize") && method.getParameterTypes().length == 0) {
            return null;
        }
        args = args != null ? args : new Object[]{};
        JSCall call = new JSCall(new JSMethod(this.target, method), args);
        return this.target.getResolver().execute(this.context, call);
    }
}

