/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.page.extension;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.graphene.page.extension.PageExtensionInstallator;
import org.jboss.arquillian.graphene.page.extension.PageExtensionInstallatorProvider;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistry;
import org.jboss.arquillian.graphene.spi.page.PageExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPageExtensionInstallatorProvider
implements PageExtensionInstallatorProvider {
    private final PageExtensionRegistry registry;

    public AbstractPageExtensionInstallatorProvider(PageExtensionRegistry registry) {
        Validate.notNull((Object)registry, (String)"registry should not be null");
        this.registry = registry;
    }

    @Override
    public final PageExtensionInstallator installator(String name) {
        return this.installator(name, true);
    }

    @Override
    public final PageExtensionInstallator installator(String name, boolean checkRequirements) {
        PageExtension extension = this.getRegistry().getExtension(name);
        if (extension == null) {
            return null;
        }
        if (checkRequirements) {
            this.checkRequirements(name);
        }
        return this.createInstallator(extension);
    }

    protected final PageExtensionRegistry getRegistry() {
        return this.registry;
    }

    private void checkRequirements(String extensionName) {
        ArrayList<String> stack = new ArrayList<String>();
        stack.add(extensionName);
        this.checkRequirements(stack);
    }

    private void checkRequirements(List<String> stack) {
        PageExtension top = this.getRegistry().getExtension(stack.get(stack.size() - 1));
        if (top == null) {
            throw new IllegalArgumentException("There is no registered extension '" + stack.get(stack.size() - 1) + "'.");
        }
        for (String requiredName : top.getRequired()) {
            PageExtension required = this.getRegistry().getExtension(requiredName);
            for (String onStack : stack) {
                if (!required.getName().equals(onStack)) continue;
                throw new IllegalStateException("There is a cycle in page extension requirements, DFS stack: " + stack);
            }
            stack.add(required.getName());
            this.checkRequirements(stack);
        }
        stack.remove(stack.size() - 1);
    }

    public abstract PageExtensionInstallator createInstallator(PageExtension var1);
}

