/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.LinkedList;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.AbstractSearchContextEnricher;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.exception.PageObjectInitializationException;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.proxy.GrapheneContextualHandler;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.openqa.selenium.SearchContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageObjectEnricher
extends AbstractSearchContextEnricher {
    public void enrich(SearchContext searchContext, Object target) {
        String errorMsgBegin = "";
        LinkedList<Field> fields = new LinkedList<Field>();
        fields.addAll(ReflectionHelper.getFieldsWithAnnotation(target.getClass(), Page.class));
        for (Field field : fields) {
            SearchContext localSearchContext;
            GrapheneContext grapheneContext;
            GrapheneContext grapheneContext2 = grapheneContext = searchContext == null ? null : ((GrapheneProxyInstance)searchContext).getContext();
            if (grapheneContext == null) {
                grapheneContext = GrapheneContext.getContextFor(ReflectionHelper.getQualifier(field.getAnnotations()));
                localSearchContext = grapheneContext.getWebDriver(new Class[]{SearchContext.class});
            } else {
                localSearchContext = searchContext;
            }
            try {
                Type type = field.getGenericType();
                Class<?> declaredClass = type instanceof TypeVariable ? this.getActualType(field, target) : field.getType();
                errorMsgBegin = "Can not instantiate Page Object " + NEW_LINE + declaredClass + NEW_LINE + " declared in: " + NEW_LINE + target.getClass().getName() + NEW_LINE;
                Object page = PageObjectEnricher.setupPage(grapheneContext, localSearchContext, declaredClass);
                PageObjectEnricher.setValue(field, target, page);
            }
            catch (NoSuchMethodException ex) {
                throw new PageObjectInitializationException(errorMsgBegin + " Check whether declared Page Object has no argument constructor!", ex);
            }
            catch (IllegalAccessException ex) {
                throw new PageObjectInitializationException(" Check whether declared Page Object has public no argument constructor!", ex);
            }
            catch (InstantiationException ex) {
                throw new PageObjectInitializationException(errorMsgBegin + " Check whether you did not declare Page Object with abstract type!", ex);
            }
            catch (Exception ex) {
                throw new PageObjectInitializationException(errorMsgBegin, ex);
            }
        }
    }

    public static <P> P setupPage(GrapheneContext context, SearchContext searchContext, Class<?> pageClass) throws Exception {
        Object page = PageObjectEnricher.instantiate(pageClass, new Object[0]);
        Object proxy = GrapheneProxy.getProxyForHandler(GrapheneContextualHandler.forTarget(context, page), pageClass, new Class[0]);
        PageObjectEnricher.enrichRecursively(searchContext, page);
        PageObjectEnricher.enrichRecursively(searchContext, proxy);
        return (P)proxy;
    }

    public int getPrecedence() {
        return 1;
    }
}

