/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition.locator;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.graphene.condition.AbstractBooleanConditionFactory;
import org.jboss.arquillian.graphene.condition.AttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.BooleanConditionWrapper;
import org.jboss.arquillian.graphene.condition.ElementConditionFactory;
import org.jboss.arquillian.graphene.condition.StringConditionFactory;
import org.jboss.arquillian.graphene.condition.attribute.LocatorAttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.locator.LocatorElementTextConditionFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementLocatorConditionFactory
extends AbstractBooleanConditionFactory<ElementConditionFactory>
implements ElementConditionFactory {
    private final By locator;
    private final SearchContext searchContext;
    protected static final Logger LOGGER = Logger.getLogger(ElementLocatorConditionFactory.class.getName());

    public ElementLocatorConditionFactory(By locator) {
        if (locator == null) {
            throw new IllegalArgumentException("The locator can't be null.");
        }
        this.locator = locator;
        this.searchContext = null;
    }

    public ElementLocatorConditionFactory(SearchContext searchContext, By locator) {
        if (searchContext == null) {
            throw new IllegalArgumentException("The search context can't be null.");
        }
        if (locator == null) {
            throw new IllegalArgumentException("The locator can't be null.");
        }
        this.locator = locator;
        this.searchContext = searchContext;
    }

    @Override
    public ExpectedCondition<Boolean> isVisible() {
        return new BooleanConditionWrapper(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return ElementLocatorConditionFactory.this.findElement(ElementLocatorConditionFactory.this.locator, driver).isDisplayed();
            }

            public String toString() {
                return String.format("element %s to be visible", ElementLocatorConditionFactory.this.locator);
            }
        }, this.getNegation(), new Class[0]);
    }

    @Override
    public ExpectedCondition<Boolean> isPresent() {
        return new BooleanConditionWrapper(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    ElementLocatorConditionFactory.this.findElement(ElementLocatorConditionFactory.this.locator, driver);
                    return true;
                }
                catch (NoSuchElementException ignored) {
                    return false;
                }
            }

            public String toString() {
                return String.format("element %s to be present", ElementLocatorConditionFactory.this.locator);
            }
        }, this.getNegation(), new Class[0]);
    }

    @Override
    public ExpectedCondition<Boolean> isSelected() {
        return new BooleanConditionWrapper(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return ElementLocatorConditionFactory.this.findElement(ElementLocatorConditionFactory.this.locator, driver).isSelected();
            }

            public String toString() {
                return String.format("element %s to be selected", ElementLocatorConditionFactory.this.locator);
            }
        }, this.getNegation(), new Class[0]);
    }

    @Override
    public ExpectedCondition<Boolean> isEnabled() {
        return new BooleanConditionWrapper(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return ElementLocatorConditionFactory.this.findElement(ElementLocatorConditionFactory.this.locator, driver).isEnabled();
            }

            public String toString() {
                return String.format("element %s to be enabled", ElementLocatorConditionFactory.this.locator);
            }
        }, this.getNegation(), new Class[0]);
    }

    public StringConditionFactory text() {
        return this.getNegation() ? (StringConditionFactory)new LocatorElementTextConditionFactory(this.searchContext, this.locator).not() : new LocatorElementTextConditionFactory(this.searchContext, this.locator);
    }

    @Override
    protected ElementConditionFactory copy() {
        ElementLocatorConditionFactory copy = this.searchContext != null ? new ElementLocatorConditionFactory(this.searchContext, this.locator) : new ElementLocatorConditionFactory(this.locator);
        copy.setNegation(this.getNegation());
        return copy;
    }

    @Override
    public AttributeConditionFactory attribute(String attribute) {
        return new LocatorAttributeConditionFactory(this.searchContext, this.locator, attribute);
    }

    protected WebElement findElement(By by, WebDriver driver) {
        try {
            return (this.searchContext == null ? driver : this.searchContext).findElement(by);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (WebDriverException e) {
            LOGGER.log(Level.FINE, String.format("WebDriverException thrown by findElement(%s)", by), e);
            throw e;
        }
    }
}

