/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.proxy;

import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrapheneProxyUtil {
    public static Class<?>[] getInterfaces(Class<?> ... targetClasses) {
        HashSet classes = new HashSet();
        HashSet<Class> inspected = new HashSet<Class>();
        LinkedList queue = new LinkedList();
        queue.addAll(Arrays.asList(targetClasses));
        while (!queue.isEmpty()) {
            Class clazz = (Class)queue.poll();
            if (inspected.contains(clazz) || clazz.isInterface() && classes.contains(clazz)) continue;
            inspected.add(clazz);
            classes.add(clazz);
            classes.addAll(Arrays.asList(clazz.getInterfaces()));
            queue.addAll(Arrays.asList(clazz.getInterfaces()));
            if (clazz.getSuperclass() == null) continue;
            classes.add(clazz.getSuperclass());
            queue.add(clazz.getSuperclass());
        }
        LinkedList<Class> interfaces = new LinkedList<Class>();
        for (Class clazz : classes) {
            if (!clazz.isInterface()) continue;
            interfaces.add(clazz);
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static Class<?>[] concatClasses(Class<?>[] classes, Class<?> clazz) {
        for (Class<?> c : classes) {
            if (!clazz.equals(c)) continue;
            return classes;
        }
        int length = classes.length;
        Class[] out = new Class[length + 1];
        System.arraycopy(classes, 0, out, 0, length);
        out[length] = clazz;
        return out;
    }

    public static boolean isProxy(Class<?> clazz) {
        if (clazz.equals(Object.class)) {
            return false;
        }
        if (org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.Proxy.isProxyClass(clazz) || Proxy.isProxyClass(clazz)) {
            return true;
        }
        for (Class<?> interfaze : clazz.getInterfaces()) {
            if (!interfaze.getName().endsWith(".cglib.proxy.Factory")) continue;
            return true;
        }
        return false;
    }

    public static boolean isProxy(Object target) {
        return GrapheneProxyUtil.isProxy(target.getClass());
    }
}

