/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.location;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.impl.enricher.resource.URLResourceProvider;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizableURLResourceProvider
extends URLResourceProvider {
    @Inject
    private Instance<GrapheneConfiguration> grapheneConfiguration;
    @Inject
    private Instance<TestClass> testClass;

    public boolean canProvide(Class<?> type) {
        return super.canProvide(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        String grapheneCustomURL;
        URL url = null;
        url = this.hasDeployment((TestClass)this.testClass.get()) ? (URL)super.lookup(resource, qualifiers) : (URL)super.doLookup(resource, qualifiers);
        if (url == null && (grapheneCustomURL = ((GrapheneConfiguration)this.grapheneConfiguration.get()).getUrl()) != null) {
            try {
                url = new URL(grapheneCustomURL);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException("Configured custom URL from GrapheneConfiguration should be already a valid URL.");
            }
        }
        return url;
    }

    private boolean hasDeployment(TestClass testClass) {
        return testClass.getMethods(Deployment.class).length != 0;
    }
}

