/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.javascript;

import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.TestingDriverStub;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.javascript.AbstractJavaScriptTest;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.graphene.javascript.TestingEnum;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.openqa.selenium.WebDriver;

public class TestReturnValues
extends AbstractJavaScriptTest {
    @Spy
    TestingDriverStub executor = new TestingDriverStub();
    TestingInterface instance;
    Object answer;

    @Before
    public void prepareTest() {
        MockitoAnnotations.initMocks((Object)this);
        this.instance = (TestingInterface)JSInterfaceFactory.create((GrapheneContext)GrapheneContext.setContextFor((GrapheneConfiguration)new GrapheneConfiguration(), (WebDriver)this.executor, Default.class), TestingInterface.class);
        Mockito.when((Object)this.executor.executeScript(Mockito.anyString(), new Object[0])).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return TestReturnValues.this.answer;
            }
        });
        Mockito.when((Object)this.executor.executeScript("return true;", new Object[0])).thenReturn((Object)true);
    }

    @Test
    public void test_voidMethod() {
        this.instance.voidMethod();
        ((TestingDriverStub)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("base", "voidMethod"), new Object[0]);
    }

    @Test
    public void test_returnString() {
        this.answer = "someString";
        String result = this.instance.returnString();
        Assert.assertEquals((Object)this.answer, (Object)result);
        ((TestingDriverStub)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("base", "returnString"), new Object[0]);
    }

    @Test
    public void test_returnInteger() {
        this.answer = 1;
        int result = this.instance.returnInteger();
        Assert.assertEquals((Object)this.answer, (Object)result);
        ((TestingDriverStub)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("base", "returnInteger"), new Object[0]);
    }

    @Test
    public void test_returnIntegerObject() {
        this.answer = 1;
        Integer result = this.instance.returnIntegerObject();
        Assert.assertEquals((Object)this.answer, (Object)result);
        ((TestingDriverStub)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("base", "returnIntegerObject"), new Object[0]);
    }

    @Test
    public void test_returnIntegerObject_null() {
        this.answer = null;
        Integer result = this.instance.returnIntegerObject();
        Assert.assertEquals((Object)this.answer, (Object)result);
        ((TestingDriverStub)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("base", "returnIntegerObject"), new Object[0]);
    }

    @Test
    public void test_returnEnumValue() {
        this.answer = "VALUE2";
        TestingEnum result = this.instance.returnEnumValue();
        Assert.assertEquals((Object)((Object)TestingEnum.VALUE2), (Object)((Object)result));
        ((TestingDriverStub)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("base", "returnEnumValue"), new Object[0]);
    }

    @JavaScript(value="base")
    public static interface TestingInterface {
        public void voidMethod();

        public String returnString();

        public int returnInteger();

        public Integer returnIntegerObject();

        public TestingEnum returnEnumValue();
    }
}

