/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import org.jboss.arquillian.graphene.enricher.AbstractGrapheneEnricherTest;
import org.jboss.arquillian.graphene.enricher.exception.PageObjectInitializationException;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Test;

public class TestPageObjectEnricher
extends AbstractGrapheneEnricherTest {
    @Test
    public void testNoArgConstructor() {
        this.thrown.expect(PageObjectInitializationException.class);
        this.getGrapheneEnricher().enrich((Object)new NoArgConstructorTest());
    }

    @Test
    public void testNoArgConstructorResolveMethod() throws NoSuchMethodException {
        this.thrown.expect(PageObjectInitializationException.class);
        this.getGrapheneEnricher().resolve(NoArgConstructorMethodParamTest.class.getMethod("methodToResolve", NoArgConstructorMethodParamTest.WrongPageObject.class));
    }

    @Test
    public void testAbstractType() {
        this.thrown.expect(PageObjectInitializationException.class);
        this.getGrapheneEnricher().enrich((Object)new AbstractTypeTest());
    }

    @Test
    public void testAbstractTypeResolveMethod() throws NoSuchMethodException {
        this.thrown.expect(PageObjectInitializationException.class);
        this.getGrapheneEnricher().resolve(AbstractTypeMethodParamTest.class.getMethod("methodToResolve", AbstractPageType.class));
    }

    public abstract class AbstractPageType {
    }

    public static class NoArgConstructorMethodParamTest {
        public void methodToResolve(@Page WrongPageObject wrongPage) {
        }

        public static class WrongPageObject {
            public WrongPageObject(int foo) {
            }
        }
    }

    public static class NoArgConstructorTest {
        @Page
        private WrongPageObject wrongPage;

        public static class WrongPageObject {
            public WrongPageObject(int foo) {
            }
        }
    }

    public class AbstractTypeMethodParamTest {
        public void methodToResolve(@Page AbstractPageType wrongPage) {
        }
    }

    public class AbstractTypeTest {
        @Page
        private AbstractPageType wrongPage;
    }
}

