/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.proxy;

import net.sf.cglib.proxy.MethodInterceptor;
import org.jboss.arquillian.graphene.proxy.ClassImposterizer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestClassImposterizer {
    @Mock
    MethodInterceptor interceptor;

    @Test
    public void testClass() {
        Object object = ClassImposterizer.INSTANCE.imposterise(this.interceptor, TestingClass.class, new Class[0]);
        Assert.assertTrue((boolean)(object instanceof TestingClass));
    }

    @Test
    public void testInterface() {
        Object object = ClassImposterizer.INSTANCE.imposterise(this.interceptor, TestingInterface.class, new Class[0]);
        Assert.assertTrue((boolean)(object instanceof TestingInterface));
    }

    @Test
    public void testAbstractClass() {
        Object object = ClassImposterizer.INSTANCE.imposterise(this.interceptor, TestingAbstractClass.class, new Class[0]);
        Assert.assertTrue((boolean)(object instanceof TestingAbstractClass));
    }

    @Test
    public void testClassAndInterface() {
        Object object = ClassImposterizer.INSTANCE.imposterise(this.interceptor, TestingClass.class, new Class[]{TestingInterface.class});
        Assert.assertTrue((boolean)(object instanceof TestingClass));
        Assert.assertTrue((boolean)(object instanceof TestingInterface));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrivateInterface() {
        Object object = ClassImposterizer.INSTANCE.imposterise(this.interceptor, TestingPrivateInterface.class, new Class[0]);
        Assert.assertTrue((boolean)(object instanceof TestingPrivateInterface));
    }

    private static interface TestingPrivateInterface {
    }

    public static interface TestingInterface {
    }

    public static class TestingAbstractClass {
    }

    public static class TestingClass {
    }
}

