/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.spi.enricher.SearchContextTestEnricher;
import org.openqa.selenium.SearchContext;

public class FieldAccessValidatorEnricher
implements SearchContextTestEnricher {
    private static final Logger LOGGER = Logger.getLogger(FieldAccessValidatorEnricher.class.getName());

    public void enrich(SearchContext searchContext, Object target) {
        List<Field> fields = ReflectionHelper.getFields(target.getClass());
        for (Field field : fields) {
            this.checkFieldValidity(searchContext, target, field);
        }
    }

    protected void checkFieldValidity(SearchContext searchContext, Object target, Field field) {
        if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) {
            String message;
            if (searchContext != null && field.isAccessible() || Modifier.isPublic(field.getModifiers())) {
                message = "Public field '" + field.getName() + "' found in " + target.getClass().getName() + ". Direct access to fields outside of the declaring class is not allowed.";
                LOGGER.warning(message);
            }
            if (!(searchContext == null || field.getName().startsWith("this$") || Modifier.isPrivate(field.getModifiers()) || Modifier.isProtected(field.getModifiers()))) {
                message = "Package-friendly field '" + field.getName() + "' found in " + target.getClass().getName() + ". Direct access to fields outside of the declaring class is not allowed.";
                LOGGER.warning(message);
            }
        }
    }

    public Object[] resolve(SearchContext searchContext, Method method, Object[] resolvedParams) {
        return resolvedParams;
    }

    public int getPrecedence() {
        return 1;
    }
}

