/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.spi;

import org.jboss.arquillian.graphene.spi.ImplementedBy;
import org.jboss.arquillian.graphene.spi.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeResolver {
    public static <T> Class<? extends T> resolveType(String typeName) {
        try {
            Class<?> clazz = Class.forName(typeName);
            return TypeResolver.resolveType(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(String.format("Cannot find class %s. Make sure you have respective implementation (e.g. graphene-webdriver-impl.jar) included on the classpath.", typeName), e);
        }
    }

    public static <T> Class<? extends T> resolveType(Class<T> type) {
        ImplementedBy implementedBy = type.getAnnotation(ImplementedBy.class);
        if (implementedBy != null) {
            if (implementedBy.value() != ImplementedBy.class) {
                return TypeResolver.resolveType(implementedBy.value());
            }
            if (!"".equals(implementedBy.className())) {
                return TypeResolver.resolveType(implementedBy.className());
            }
            throw new IllegalStateException(String.format("Cannot instantiate an instance of '%s' as its %s is incomplete - it doesn't specify implementation class", type.getName(), implementedBy));
        }
        return type;
    }

    public static <T> T instantiate(String className) {
        return TypeResolver.instantiate(TypeResolver.resolveType(className));
    }

    public static <T> T instantiate(Class<T> type) {
        try {
            Class<T> resolvedType = TypeResolver.resolveType(type);
            return SecurityActions.newInstance(resolvedType.getName(), new Class[0], new Object[0], type);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Cannot instantiate an instance of class '%s': %s", type.getName(), e.getMessage()), e);
        }
    }
}

