/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi.internal;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.osgi.internal.AbstractOSGiContainer;
import org.jboss.arquillian.osgi.internal.JMXServiceURLFactory;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.logging.Logger;
import org.osgi.framework.BundleContext;

public class RemoteOSGiContainer
extends AbstractOSGiContainer {
    private static final Logger log = Logger.getLogger(RemoteOSGiContainer.class);
    private JMXConnector jmxConnector;

    public RemoteOSGiContainer(BundleContext context, TestClass testClass) {
        super(context, testClass);
    }

    public MBeanServerConnection getMBeanServerConnection() {
        String jmxHost = this.getFrameworkProperty("org.jboss.osgi.jmx.host", "localhost");
        Integer jmxPort = Integer.parseInt(this.getFrameworkProperty("org.jboss.osgi.jmx.rmi.port", "1198"));
        Integer rmiPort = Integer.parseInt(this.getFrameworkProperty("org.jboss.osgi.jmx.rmi.registry.port", "1090"));
        JMXServiceURL serviceURL = JMXServiceURLFactory.getServiceURL(jmxHost, jmxPort + 1, rmiPort, "arquillian-osgi-callback");
        try {
            if (this.jmxConnector == null) {
                log.debug((Object)("Connecting JMXConnector to: " + serviceURL));
                this.jmxConnector = JMXConnectorFactory.connect(serviceURL, null);
            }
            return this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain MBeanServerConnection to: " + serviceURL, ex);
        }
    }

    private String getFrameworkProperty(String key, String defaultValue) {
        String value = this.getBundleContext().getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

