/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.testenricher.osgi.BundleAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleContextAssociation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ArquillianBundleActivator
implements BundleActivator {
    private static Logger log = Logger.getLogger(ArquillianBundleActivator.class.getName());
    private JMXTestRunner testRunner;

    public void start(final BundleContext context) throws Exception {
        ServiceReference sref = context.getServiceReference(PackageAdmin.class.getName());
        final PackageAdmin pa = (PackageAdmin)context.getService(sref);
        final JMXTestRunner.TestClassLoader testClassLoader = new JMXTestRunner.TestClassLoader(){

            public Class<?> loadTestClass(String className) throws ClassNotFoundException {
                Bundle arqBundle = context.getBundle();
                BundleContext sysContext = context.getBundle(0L).getBundleContext();
                BundleContextAssociation.setBundleContext((BundleContext)sysContext);
                Class testClass = arqBundle.loadClass(className);
                Bundle testBundle = pa.getBundle(testClass);
                BundleAssociation.setBundle((Bundle)testBundle);
                return testClass;
            }

            public ClassLoader getServiceClassLoader() {
                return ArquillianBundleActivator.class.getClassLoader();
            }
        };
        MBeanServer mbeanServer = this.getMBeanServer(context);
        this.testRunner = new JMXTestRunner(){

            protected JMXTestRunner.TestClassLoader getTestClassLoader() {
                return testClassLoader;
            }
        };
        this.testRunner.registerMBean(mbeanServer);
    }

    public void stop(BundleContext context) throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer(context);
        this.testRunner.unregisterMBean(mbeanServer);
    }

    private MBeanServer getMBeanServer(BundleContext context) {
        ServiceReference sref = context.getServiceReference(MBeanServer.class.getName());
        if (sref != null) {
            MBeanServer mbeanServer = (MBeanServer)context.getService(sref);
            log.fine("Found MBeanServer fom service: " + mbeanServer.getDefaultDomain());
            return mbeanServer;
        }
        return this.findOrCreateMBeanServer();
    }

    private MBeanServer findOrCreateMBeanServer() {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            log.warning("Multiple MBeanServer instances: " + serverArr);
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            log.fine("Found MBeanServer: " + mbeanServer.getDefaultDomain());
        }
        if (mbeanServer == null) {
            log.fine("No MBeanServer, create one ...");
            mbeanServer = MBeanServerFactory.createMBeanServer();
        }
        return mbeanServer;
    }
}

