/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public final class RepositoryArchiveLocator {
    private RepositoryArchiveLocator() {
    }

    public static URL getArtifactURL(String artifactId) {
        return RepositoryArchiveLocator.getArtifactURL(null, artifactId, null);
    }

    public static URL getArtifactURL(String groupId, String artifactId, String version) {
        String userHome;
        File repositoryDir;
        File groupDir;
        String archiveDir;
        String classPath;
        if (artifactId == null) {
            throw new IllegalArgumentException("Null artifactId");
        }
        String groupPath = null;
        if (groupId != null) {
            groupPath = groupId.replace('.', '/');
        }
        if ((classPath = System.getProperty("java.class.path")) != null) {
            String[] paths;
            for (String path : paths = classPath.split(File.pathSeparator)) {
                boolean groupMatch = groupPath == null || path.contains(File.separator + groupPath + File.separator);
                boolean artifactMatch = path.contains(File.separator + artifactId + File.separator);
                if (!groupMatch || !artifactMatch) continue;
                return RepositoryArchiveLocator.failsafeURL(path);
            }
        }
        if ((archiveDir = System.getProperty("test.archive.directory")) != null) {
            File file = new File(archiveDir + "/" + artifactId + ".jar");
            if (file.exists()) {
                return RepositoryArchiveLocator.failsafeURL(file.getAbsolutePath());
            }
            file = new File(archiveDir + "/bundles/" + artifactId + ".jar");
            if (file.exists()) {
                return RepositoryArchiveLocator.failsafeURL(file.getAbsolutePath());
            }
        }
        if ((groupDir = new File((repositoryDir = new File((userHome = System.getProperty("user.home")) + "/.m2/repository")) + "/" + groupPath)).exists() && version != null) {
            String pathname = groupDir + "/" + artifactId + "/";
            File file = new File(pathname = pathname + version + "/" + artifactId + "-" + version + ".jar");
            if (file.exists()) {
                return RepositoryArchiveLocator.failsafeURL(file.getAbsolutePath());
            }
        }
        return null;
    }

    private static URL failsafeURL(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            try {
                File file = new File(path);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            throw new IllegalArgumentException("Invalid path: " + path);
        }
    }
}

