/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.testenricher.osgi.BundleContextHolder;
import org.jboss.arquillian.testenricher.osgi.OSGiTestEnricher;
import org.jboss.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ArquillianBundleActivator
implements BundleActivator {
    private static Logger log = Logger.getLogger(ArquillianBundleActivator.class);
    private JMXTestRunner testRunner;

    public void start(final BundleContext context) throws Exception {
        JMXTestRunner.TestClassLoader loader = new JMXTestRunner.TestClassLoader(){

            public Class<?> loadTestClass(String className) throws ClassNotFoundException {
                Bundle bundle = context.getBundle();
                return bundle.loadClass(className);
            }
        };
        MBeanServer mbeanServer = this.getMBeanServer(context);
        this.testRunner = new JMXTestRunner(loader);
        this.testRunner.registerMBean(mbeanServer);
        BundleContextHolder holder = new BundleContextHolder(){

            public BundleContext getBundleContext() {
                return context;
            }
        };
        StandardMBean holderMBean = new StandardMBean(holder, BundleContextHolder.class);
        mbeanServer.registerMBean(holderMBean, new ObjectName("jboss.arquillian:service=bundle-context"));
    }

    public void stop(BundleContext context) throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer(context);
        this.testRunner.unregisterMBean(mbeanServer);
        mbeanServer.unregisterMBean(new ObjectName("jboss.arquillian:service=bundle-context"));
    }

    private MBeanServer getMBeanServer(BundleContext context) {
        ServiceReference sref = context.getServiceReference(MBeanServer.class.getName());
        if (sref != null) {
            MBeanServer mbeanServer = (MBeanServer)context.getService(sref);
            log.debug((Object)("Found MBeanServer fom service: " + mbeanServer.getDefaultDomain()));
            return mbeanServer;
        }
        return OSGiTestEnricher.findOrCreateMBeanServer();
    }
}

