/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXMethodExecutor
implements ContainerMethodExecutor {
    private MBeanServerConnection mbeanServer;
    private Properties properties;

    public JMXMethodExecutor(MBeanServerConnection connection, Properties props) {
        if (connection == null) {
            throw new IllegalArgumentException("Null connection");
        }
        this.mbeanServer = connection;
        this.properties = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        if (testMethodExecutor == null) {
            throw new IllegalArgumentException("TestMethodExecutor null");
        }
        Object testInstance = testMethodExecutor.getInstance();
        String testClass = testInstance.getClass().getName();
        String testMethod = testMethodExecutor.getMethod().getName();
        TestResult result = null;
        try {
            ObjectName objectName = new ObjectName("jboss.arquillian:service=jmx-test-runner");
            JMXTestRunnerMBean testRunner = this.getMBeanProxy(objectName, JMXTestRunnerMBean.class);
            ExecutionType type = (ExecutionType)((Object)this.properties.get(ExecutionType.class));
            if (type == ExecutionType.EMBEDDED) {
                byte[] resultBytes = testRunner.runTestMethodSerialized(testClass, testMethod, this.properties);
                ByteArrayInputStream resultStream = new ByteArrayInputStream(resultBytes);
                ObjectInputStream ois = new ObjectInputStream(resultStream);
                result = (TestResult)ois.readObject();
            } else {
                result = testRunner.runTestMethod(testClass, testMethod, this.properties);
            }
        }
        catch (Throwable e) {
            result = new TestResult(TestResult.Status.FAILED);
            result.setThrowable(e);
        }
        finally {
            result.setEnd(System.currentTimeMillis());
        }
        return result;
    }

    private <T> T getMBeanProxy(ObjectName name, Class<T> interf) {
        return MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, name, interf, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExecutionType {
        EMBEDDED,
        REMOTE;

    }
}

