/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.protocol.jmx.DefaultSocketFactory;
import org.jboss.logging.Logger;

public class JMXConnectorServerExt {
    private static final Logger log = Logger.getLogger(JMXConnectorServerExt.class);
    private JMXServiceURL serviceURL;
    private JMXConnectorServer jmxConnectorServer;
    private boolean shutdownRegistry;
    private Registry rmiRegistry;

    public JMXConnectorServerExt(JMXServiceURL serviceURL, int regPort) throws IOException {
        this.serviceURL = serviceURL;
        String host = serviceURL.getHost();
        this.rmiRegistry = LocateRegistry.getRegistry(host, regPort);
        try {
            this.rmiRegistry.list();
            log.debug((Object)("RMI registry running at host=" + host + ",port=" + regPort));
        }
        catch (Exception ex) {
            log.debug((Object)("No RMI registry running at host=" + host + ",port=" + regPort + ".  Will create one."));
            this.rmiRegistry = LocateRegistry.createRegistry(regPort, null, new DefaultSocketFactory(InetAddress.getByName(host)));
            this.shutdownRegistry = true;
        }
    }

    public void start(MBeanServer mbeanServer) throws IOException {
        this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.serviceURL, null, mbeanServer);
        log.debug((Object)("JMXConnectorServer created: " + this.serviceURL));
        this.jmxConnectorServer.start();
        log.debug((Object)("JMXConnectorServer started: " + this.serviceURL));
    }

    public void stop() {
        try {
            this.jmxConnectorServer.stop();
            if (this.shutdownRegistry) {
                log.debug((Object)"Shutdown RMI registry");
                UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
            }
            log.debug((Object)"JMXConnectorServer stopped");
        }
        catch (IOException ex) {
            log.warn((Object)"Cannot stop JMXConnectorServer", (Throwable)ex);
        }
    }
}

