/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.arquillian.protocol.jmx.JMXMethodExecutor;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.TestRunner;
import org.jboss.arquillian.spi.util.TestRunners;
import org.jboss.logging.Logger;

public class JMXTestRunner
implements JMXTestRunnerMBean {
    private static Logger log = Logger.getLogger(JMXTestRunner.class);
    private static ThreadLocal<JMXMethodExecutor.ExecutionType> executionTypeAssociation = new ThreadLocal();
    private TestClassLoader testClassLoader;

    public JMXTestRunner(TestClassLoader classLoader) {
        this.testClassLoader = classLoader;
        if (this.testClassLoader == null) {
            this.testClassLoader = new TestClassLoader(){

                @Override
                public Class<?> loadTestClass(String className) throws ClassNotFoundException {
                    ClassLoader classLoader = JMXTestRunner.class.getClassLoader();
                    return classLoader.loadClass(className);
                }
            };
        }
    }

    public static JMXMethodExecutor.ExecutionType getExecutionType() {
        return executionTypeAssociation.get();
    }

    public ObjectName registerMBean(MBeanServer mbeanServer) throws JMException {
        ObjectName oname = new ObjectName("jboss.arquillian:service=jmx-test-runner");
        mbeanServer.registerMBean(this, oname);
        log.debug((Object)("JMXTestRunner registered: " + oname));
        return oname;
    }

    public void unregisterMBean(MBeanServer mbeanServer) throws JMException {
        ObjectName oname = new ObjectName("jboss.arquillian:service=jmx-test-runner");
        if (mbeanServer.isRegistered(oname)) {
            mbeanServer.unregisterMBean(oname);
            log.debug((Object)("JMXTestRunner unregistered: " + oname));
        }
    }

    public TestResult runTestMethod(String className, String methodName, Properties props) {
        return this.runTestMethodInternal(className, methodName, props);
    }

    public byte[] runTestMethodSerialized(String className, String methodName, Properties props) {
        TestResult result = this.runTestMethodInternal(className, methodName, props);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(result);
            oos.close();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot marshall response", ex);
        }
    }

    private TestResult runTestMethodInternal(String className, String methodName, Properties props) {
        if (props != null) {
            JMXMethodExecutor.ExecutionType executionType = (JMXMethodExecutor.ExecutionType)((Object)props.get(JMXMethodExecutor.ExecutionType.class));
            executionTypeAssociation.set(executionType);
        }
        try {
            TestRunner runner = TestRunners.getTestRunner((ClassLoader)JMXTestRunner.class.getClassLoader());
            Class<?> testClass = this.testClassLoader.loadTestClass(className);
            TestResult testResult = runner.execute(testClass, methodName);
            return testResult;
        }
        catch (Throwable th) {
            return new TestResult(TestResult.Status.FAILED, th);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TestClassLoader {
        public Class<?> loadTestClass(String var1) throws ClassNotFoundException;
    }
}

