/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.arquillian.api.ArchiveProvider;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.protocol.jmx.RequestedCommand;
import org.jboss.arquillian.protocol.jmx.Utils;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class JMXMethodExecutor
implements ContainerMethodExecutor {
    private static final Logger log = Logger.getLogger(JMXMethodExecutor.class.getName());
    private final MBeanServerConnection mbeanServer;
    private final ExecutionType executionType;
    private final Map<String, String> props;
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public JMXMethodExecutor(MBeanServerConnection connection, ExecutionType executionType) {
        this.mbeanServer = connection;
        this.executionType = executionType;
        this.props = new HashMap<String, String>();
        this.props.put(ExecutionType.class.getName(), executionType.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        NotificationListener listener;
        TestResult result;
        block13: {
            if (testMethodExecutor == null) {
                throw new IllegalArgumentException("TestMethodExecutor null");
            }
            Object testInstance = testMethodExecutor.getInstance();
            final String testClass = testInstance.getClass().getName();
            final String testMethod = testMethodExecutor.getMethod().getName();
            result = null;
            listener = null;
            try {
                final JMXTestRunnerMBean testRunner = this.getMBeanProxy(JMXTestRunnerMBean.OBJECT_NAME, JMXTestRunnerMBean.class);
                listener = this.registerNotificationListener(JMXTestRunnerMBean.OBJECT_NAME, testRunner, testInstance);
                if (this.executionType == ExecutionType.EMBEDDED) {
                    InputStream resultStream = this.executor.submit(new Callable<InputStream>(){

                        @Override
                        public InputStream call() throws Exception {
                            return testRunner.runTestMethodEmbedded(testClass, testMethod, JMXMethodExecutor.this.props);
                        }
                    }).get();
                    try {
                        result = Utils.deserialize(resultStream, TestResult.class);
                        break block13;
                    }
                    finally {
                        try {
                            resultStream.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
                if (this.executionType != ExecutionType.REMOTE) break block13;
                result = testRunner.runTestMethod(testClass, testMethod, this.props);
            }
            catch (Throwable e) {
                try {
                    result = new TestResult(TestResult.Status.FAILED);
                    result.setThrowable(e);
                }
                catch (Throwable throwable) {
                    result.setEnd(System.currentTimeMillis());
                    this.unregisterNotificationListener(JMXTestRunnerMBean.OBJECT_NAME, listener);
                    throw throwable;
                }
                result.setEnd(System.currentTimeMillis());
                this.unregisterNotificationListener(JMXTestRunnerMBean.OBJECT_NAME, listener);
            }
        }
        result.setEnd(System.currentTimeMillis());
        this.unregisterNotificationListener(JMXTestRunnerMBean.OBJECT_NAME, listener);
        return result;
    }

    private NotificationListener registerNotificationListener(ObjectName name, final JMXTestRunnerMBean testRunner, Object testInstance) {
        final Method apMethod = JMXMethodExecutor.findAnnotatedMethod(testInstance.getClass(), ArchiveProvider.class);
        if (apMethod == null) {
            return null;
        }
        log.fine("Found ArchiveProvider method: " + apMethod);
        if (!Modifier.isStatic(apMethod.getModifiers())) {
            throw new IllegalStateException("Non-static ArchiveProvider on " + apMethod);
        }
        if (!Archive.class.isAssignableFrom(apMethod.getReturnType())) {
            throw new IllegalStateException("ArchiveProvider annotated method should return an instance of " + Archive.class + " :" + apMethod);
        }
        if (!Arrays.equals(new Class[]{String.class}, apMethod.getParameterTypes())) {
            throw new IllegalStateException("ArchiveProvider annotated method should take String parameter: " + apMethod);
        }
        NotificationListener nl = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                log.fine("Received JMX notification " + notification);
                if ("org.jboss.arquillian.protocol.jmx.request_command".equals(notification.getType()) && notification.getUserData() instanceof byte[]) {
                    try {
                        RequestedCommand command = Utils.deserialize((byte[])notification.getUserData(), RequestedCommand.class);
                        JMXMethodExecutor.this.handleRequestedCommand(testRunner, apMethod, command);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot un-marshal the JMX RequestedCommand notification", e);
                    }
                } else {
                    log.warning("Ignored unrecognized notification: " + notification);
                }
            }
        };
        try {
            this.mbeanServer.addNotificationListener(name, nl, null, null);
            log.fine("Registered JMX Notification Listener for " + name);
            return nl;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to register JMX notification listener for: " + name);
        }
    }

    private void unregisterNotificationListener(ObjectName name, NotificationListener listener) {
        try {
            this.mbeanServer.removeNotificationListener(name, listener);
        }
        catch (Exception e) {
            log.warning("Problem removing notification listener from MBean " + name);
        }
    }

    private void handleRequestedCommand(JMXTestRunnerMBean testRunner, Method apMethod, RequestedCommand requestedCommand) {
        switch (requestedCommand.getCommand()) {
            case RESOURCE: {
                this.handleResourceCommand(testRunner, requestedCommand, apMethod);
            }
        }
    }

    private void handleResourceCommand(JMXTestRunnerMBean testRunner, RequestedCommand requestedCommand, Method apMethod) {
        if (requestedCommand.getArguments().length >= 1) {
            ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(JavaArchive.class.getClassLoader());
                Archive archive = (Archive)apMethod.invoke(null, requestedCommand.getArguments()[0]);
                ZipExporter ze = (ZipExporter)archive.as(ZipExporter.class);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ze.exportZip((OutputStream)baos);
                testRunner.commandResult(requestedCommand.getId(), baos.toByteArray());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevCl);
            }
        }
    }

    private <T> T getMBeanProxy(ObjectName name, Class<T> interf) {
        return MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, name, interf, false);
    }

    private static Method findAnnotatedMethod(Class<?> cls, Class<? extends Annotation> annotation) {
        Method[] methods;
        for (Method method : methods = cls.getMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            return method;
        }
        return null;
    }

    public static enum ExecutionType {
        EMBEDDED,
        REMOTE;

    }
}

