/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.StandardEmitterMBean;
import org.jboss.arquillian.impl.DynamicServiceLoader;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.protocol.jmx.RequestedCommand;
import org.jboss.arquillian.protocol.jmx.ResourceCallbackHandler;
import org.jboss.arquillian.protocol.jmx.ResourceCallbackHandlerAssociation;
import org.jboss.arquillian.protocol.jmx.SecurityActions;
import org.jboss.arquillian.protocol.jmx.Utils;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.TestRunner;
import org.jboss.arquillian.spi.util.TestRunners;

public class JMXTestRunner
implements JMXTestRunnerMBean,
ResourceCallbackHandler {
    private static Logger log = Logger.getLogger(JMXTestRunner.class.getName());
    public static final String REQUEST_COMMAND = "org.jboss.arquillian.protocol.jmx.request_command";
    private StandardEmitterMBean mbean;
    private final Map<Long, BlockingQueue<byte[]>> results = new ConcurrentHashMap<Long, BlockingQueue<byte[]>>();

    public void registerMBean(MBeanServer mbeanServer) throws JMException {
        String[] types = new String[]{REQUEST_COMMAND};
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, Notification.class.getName(), "A command request event has been emitted by this mbean");
        NotificationBroadcasterSupport emitter = new NotificationBroadcasterSupport(info);
        this.mbean = new StandardEmitterMBean(this, JMXTestRunnerMBean.class, (NotificationEmitter)emitter);
        mbeanServer.registerMBean(this.mbean, OBJECT_NAME);
        log.fine("JMXTestRunner registered: " + OBJECT_NAME);
    }

    public void unregisterMBean(MBeanServer mbeanServer) throws JMException {
        if (mbeanServer.isRegistered(OBJECT_NAME)) {
            mbeanServer.unregisterMBean(OBJECT_NAME);
            log.fine("JMXTestRunner unregistered: " + OBJECT_NAME);
        }
    }

    protected TestClassLoader getTestClassLoader() {
        return new TestClassLoader(){

            @Override
            public Class<?> loadTestClass(String className) throws ClassNotFoundException {
                return this.getClass().getClassLoader().loadClass(className);
            }

            @Override
            public ClassLoader getServiceClassLoader() {
                return this.getClass().getClassLoader();
            }
        };
    }

    @Override
    public TestResult runTestMethod(String className, String methodName, Map<String, String> props) {
        return this.runTestMethodInternal(className, methodName, props);
    }

    @Override
    public InputStream runTestMethodEmbedded(String className, String methodName, Map<String, String> props) {
        TestResult result = this.runTestMethodInternal(className, methodName, props);
        try {
            return new ByteArrayInputStream(Utils.serialize((Serializable)result));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot marshall response", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestResult runTestMethodInternal(String className, String methodName, Map<String, String> props) {
        TestResult testResult;
        ResourceCallbackHandlerAssociation.setCallbackHandler(this);
        ClassLoader serviceClassLoader = this.getTestClassLoader().getServiceClassLoader();
        TestRunner runner = TestRunners.getTestRunner((ClassLoader)serviceClassLoader);
        Class<?> testClass = this.getTestClassLoader().loadTestClass(className);
        ClassLoader oldThreadContextCL = SecurityActions.getThreadContextClassLoader();
        try {
            TestResult testResult2;
            DynamicServiceLoader.setClassLoaderAssociation((ClassLoader)serviceClassLoader);
            SecurityActions.setThreadContextClassLoader(SecurityActions.getClassLoader(testClass));
            testResult = testResult2 = runner.execute(testClass, methodName);
        }
        catch (Throwable throwable) {
            try {
                SecurityActions.setThreadContextClassLoader(oldThreadContextCL);
                DynamicServiceLoader.setClassLoaderAssociation(null);
                throw throwable;
            }
            catch (Throwable th) {
                return new TestResult(TestResult.Status.FAILED, th);
            }
        }
        SecurityActions.setThreadContextClassLoader(oldThreadContextCL);
        DynamicServiceLoader.setClassLoaderAssociation(null);
        return testResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] requestResource(TestClass testClass, String resourceName) throws Exception {
        RequestedCommand command = new RequestedCommand(testClass.getName(), RequestedCommand.Command.RESOURCE, resourceName);
        try {
            ArrayBlockingQueue result = new ArrayBlockingQueue(1);
            this.results.put(command.getId(), result);
            Notification n = new Notification(REQUEST_COMMAND, (Object)this.mbean, command.getId(), "A command request for " + resourceName);
            n.setUserData(Utils.serialize(command));
            this.mbean.sendNotification(n);
            log.fine("Sent JMX notification for command request: " + command);
            byte[] byArray = (byte[])result.poll(1L, TimeUnit.MINUTES);
            return byArray;
        }
        finally {
            this.results.remove(command.getId());
        }
    }

    @Override
    public void commandResult(long commandId, byte[] result) {
        log.fine("Received result for command request with ID: " + commandId);
        BlockingQueue<byte[]> resultBQ = this.results.get(commandId);
        if (resultBQ != null) {
            resultBQ.offer(result);
        }
    }

    public static interface TestClassLoader {
        public Class<?> loadTestClass(String var1) throws ClassNotFoundException;

        public ClassLoader getServiceClassLoader();
    }
}

