/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.jmx.DummyTestCase;
import org.jboss.arquillian.protocol.jmx.JMXMethodExecutor;
import org.jboss.arquillian.protocol.jmx.JMXProtocolConfiguration;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.protocol.jmx.MockTestRunner;
import org.jboss.arquillian.protocol.jmx.TestCommand;
import org.jboss.arquillian.protocol.jmx.TestCommandCallback;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.Assert;
import org.junit.Test;

public class JMXTestRunnerTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJMXTestRunner() throws Throwable {
        MBeanServer mbeanServer = this.getMBeanServer();
        JMXTestRunner jmxTestRunner = new JMXTestRunner(null);
        ObjectName oname = jmxTestRunner.registerMBean(mbeanServer);
        try {
            JMXTestRunnerMBean testRunner = this.getMBeanProxy(mbeanServer, oname, JMXTestRunnerMBean.class);
            TestResult result = testRunner.runTestMethodRemote(DummyTestCase.class.getName(), "testMethod");
            Assert.assertNotNull((String)"TestResult not null", (Object)result);
            Assert.assertNotNull((String)"Status not null", (Object)result.getStatus());
            if (result.getStatus() == TestResult.Status.FAILED) {
                throw result.getThrowable();
            }
        }
        finally {
            mbeanServer.unregisterMBean(oname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToSendReceiveCommands() throws Throwable {
        TestCommandCallback.result = "Success";
        MockTestRunner.add(new TestResult(TestResult.Status.PASSED));
        MockTestRunner.command = new TestCommand();
        MBeanServer mbeanServer = this.getMBeanServer();
        JMXTestRunner jmxTestRunner = new JMXTestRunner(null);
        jmxTestRunner.setExposedTestRunnerForTest((TestRunner)new MockTestRunner());
        ObjectName oname = jmxTestRunner.registerMBean(mbeanServer);
        try {
            JMXProtocolConfiguration config = new JMXProtocolConfiguration();
            JMXMethodExecutor executor = new JMXMethodExecutor((MBeanServerConnection)mbeanServer, config.getExecutionType(), (CommandCallback)new TestCommandCallback());
            TestResult result = executor.invoke(new TestMethodExecutor(){

                public void invoke(Object ... parameters) throws Throwable {
                }

                public Method getMethod() {
                    return JMXTestRunnerTestCase.this.testMethod();
                }

                public Object getInstance() {
                    return JMXTestRunnerTestCase.this;
                }
            });
            Assert.assertNotNull((String)"TestResult not null", (Object)result);
            Assert.assertNotNull((String)"Status not null", (Object)result.getStatus());
            if (result.getStatus() == TestResult.Status.FAILED) {
                throw result.getThrowable();
            }
            Assert.assertEquals((String)"Should have returned command", (Object)TestCommandCallback.result, (Object)MockTestRunner.commandResult);
        }
        finally {
            mbeanServer.unregisterMBean(oname);
        }
    }

    private MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
        MBeanServer mbeanServer = mbeanServers.size() < 1 ? MBeanServerFactory.createMBeanServer() : mbeanServers.get(0);
        return mbeanServer;
    }

    private <T> T getMBeanProxy(MBeanServer mbeanServer, ObjectName name, Class<T> interf) {
        return MBeanServerInvocationHandler.newProxyInstance(mbeanServer, name, interf, false);
    }

    private Method testMethod() {
        try {
            return DummyTestCase.class.getMethod("testMethod", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not lookup testMethod, check " + DummyTestCase.class, e);
        }
    }
}

