/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.protocol.jmx.Serializer;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXMethodExecutor
implements ContainerMethodExecutor {
    private static Logger log = Logger.getLogger(JMXMethodExecutor.class.getName());
    private final MBeanServerConnection mbeanServer;
    private final String objectName;
    private final CommandCallback callback;
    private final Map<String, String> protocolProps;

    public JMXMethodExecutor(MBeanServerConnection mbeanServer, CommandCallback callback) {
        this(mbeanServer, callback, "jboss.arquillian:service=jmx-test-runner", null);
    }

    public JMXMethodExecutor(MBeanServerConnection mbeanServer, CommandCallback callback, String objectName, Map<String, String> protocolProps) {
        this.mbeanServer = mbeanServer;
        this.callback = callback;
        this.objectName = objectName;
        this.protocolProps = protocolProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        if (testMethodExecutor == null) {
            throw new IllegalArgumentException("TestMethodExecutor null");
        }
        String testClass = testMethodExecutor.getInstance().getClass().getName();
        String testMethod = testMethodExecutor.getMethod().getName();
        String testCanonicalName = testClass + "." + testMethod;
        CallbackNotificationListener commandListener = null;
        ObjectName objectName = null;
        TestResult result = null;
        try {
            objectName = new ObjectName(this.objectName);
            commandListener = new CallbackNotificationListener(objectName);
            this.mbeanServer.addNotificationListener(objectName, commandListener, null, null);
            JMXTestRunnerMBean testRunner = this.getMBeanProxy(objectName, JMXTestRunnerMBean.class);
            log.fine("Invoke " + testCanonicalName);
            result = Serializer.toObject(TestResult.class, testRunner.runTestMethod(testClass, testMethod, this.protocolProps));
        }
        catch (Throwable th) {
            result = new TestResult(TestResult.Status.FAILED);
            result.setThrowable(th);
        }
        finally {
            result.setEnd(System.currentTimeMillis());
            if (objectName != null && commandListener != null) {
                try {
                    this.mbeanServer.removeNotificationListener(objectName, commandListener);
                }
                catch (Throwable th) {
                    log.log(Level.SEVERE, "Cannot remove notification listener", th);
                }
            }
        }
        log.fine("Result: " + result);
        if (result.getStatus() == TestResult.Status.FAILED) {
            log.log(Level.SEVERE, "Failed: " + testCanonicalName, result.getThrowable());
        }
        return result;
    }

    private <T> T getMBeanProxy(ObjectName name, Class<T> interf) {
        return MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, name, interf, false);
    }

    private class CallbackNotificationListener
    implements NotificationListener {
        private ObjectName serviceName;

        public CallbackNotificationListener(ObjectName serviceName) {
            this.serviceName = serviceName;
        }

        public void handleNotification(Notification notification, Object handback) {
            String eventMessage = notification.getMessage();
            Command command = Serializer.toObject(Command.class, (byte[])notification.getUserData());
            JMXMethodExecutor.this.callback.fired(command);
            try {
                JMXMethodExecutor.this.mbeanServer.invoke(this.serviceName, "push", new Object[]{eventMessage, Serializer.toByteArray(command)}, new String[]{String.class.getName(), byte[].class.getName()});
            }
            catch (Exception e) {
                throw new RuntimeException("Could not return command result for command " + command, e);
            }
        }
    }
}

