/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.util.TestRunners;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.protocol.jmx.Serializer;
import org.jboss.arquillian.test.spi.TestResult;

public class JMXTestRunner
extends NotificationBroadcasterSupport
implements JMXTestRunnerMBean {
    static MBeanServer localMBeanServer;
    private static Logger log;
    private final String objectName;
    private ConcurrentHashMap<String, Command<?>> events;
    private ThreadLocal<String> currentCall;
    private AtomicInteger integer = new AtomicInteger();
    private TestRunner mockTestRunner;
    private TestClassLoader testClassLoader;

    public JMXTestRunner(TestClassLoader classLoader) {
        this(classLoader, "jboss.arquillian:service=jmx-test-runner");
    }

    public JMXTestRunner(TestClassLoader classLoader, String objectName) {
        this.testClassLoader = classLoader;
        if (this.testClassLoader == null) {
            this.testClassLoader = new TestClassLoader(){

                @Override
                public Class<?> loadTestClass(String className) throws ClassNotFoundException {
                    ClassLoader classLoader = JMXTestRunner.class.getClassLoader();
                    return classLoader.loadClass(className);
                }
            };
        }
        this.events = new ConcurrentHashMap();
        this.currentCall = new ThreadLocal();
        this.objectName = objectName;
    }

    public ObjectName registerMBean(MBeanServer mbeanServer) throws JMException {
        ObjectName oname = new ObjectName(this.objectName);
        mbeanServer.registerMBean(this, oname);
        log.fine("JMXTestRunner registered: " + oname);
        localMBeanServer = mbeanServer;
        return oname;
    }

    public void unregisterMBean(MBeanServer mbeanServer) throws JMException {
        ObjectName oname = new ObjectName(this.objectName);
        if (mbeanServer.isRegistered(oname)) {
            mbeanServer.unregisterMBean(oname);
            log.fine("JMXTestRunner unregistered: " + oname);
        }
        localMBeanServer = null;
    }

    @Override
    public byte[] runTestMethod(String className, String methodName) {
        TestResult result = this.runTestMethodInternal(className, methodName, new HashMap<String, String>());
        return Serializer.toByteArray(result);
    }

    @Override
    public byte[] runTestMethod(String className, String methodName, Map<String, String> protocolProps) {
        try {
            final Class<?> impl = this.getClass();
            Method m = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws NoSuchMethodException {
                    return impl.getMethod("runTestMethod", String.class, String.class);
                }
            });
            if (m.getDeclaringClass() != JMXTestRunner.class) {
                return this.runTestMethod(className, methodName);
            }
        }
        catch (Exception impl) {
            // empty catch block
        }
        TestResult result = this.runTestMethodInternal(className, methodName, protocolProps);
        return Serializer.toByteArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestResult runTestMethodInternal(String className, String methodName, Map<String, String> protocolProps) {
        this.currentCall.set(className + methodName);
        TestResult result = new TestResult();
        try {
            TestRunner runner = this.mockTestRunner;
            if (runner == null) {
                runner = TestRunners.getTestRunner((ClassLoader)this.getClass().getClassLoader());
            }
            log.fine("Load test class: " + className);
            Class<?> testClass = this.testClassLoader.loadTestClass(className);
            log.fine("Test class loaded from: " + testClass.getClassLoader());
            log.fine("Execute: " + className + "." + methodName);
            result = this.doRunTestMethod(runner, testClass, methodName, protocolProps);
        }
        catch (Throwable th) {
            result.setStatus(TestResult.Status.FAILED);
            result.setEnd(System.currentTimeMillis());
            result.setThrowable(th);
        }
        finally {
            log.fine("Result: " + result);
            if (result.getStatus() == TestResult.Status.FAILED) {
                log.log(Level.SEVERE, "Failed: " + className + "." + methodName, result.getThrowable());
            }
        }
        return result;
    }

    protected TestResult doRunTestMethod(TestRunner runner, Class<?> testClass, String methodName, Map<String, String> protocolProps) {
        return runner.execute(testClass, methodName);
    }

    @Override
    public void send(Command<?> command) {
        Notification notification = new Notification("arquillian-command", (Object)this, (long)this.integer.incrementAndGet(), this.currentCall.get());
        notification.setUserData(Serializer.toByteArray(command));
        this.sendNotification(notification);
    }

    @Override
    public Command<?> receive() {
        return this.events.remove(this.currentCall.get());
    }

    @Override
    public void push(String eventId, byte[] command) {
        this.events.put(eventId, Serializer.toObject(Command.class, command));
    }

    protected String getCurrentCall() {
        return this.currentCall.get();
    }

    protected void setCurrentCall(String current) {
        this.currentCall.set(current);
    }

    void setExposedTestRunnerForTest(TestRunner mockTestRunner) {
        this.mockTestRunner = mockTestRunner;
    }

    static {
        log = Logger.getLogger(JMXTestRunner.class.getName());
    }

    public static interface TestClassLoader {
        public Class<?> loadTestClass(String var1) throws ClassNotFoundException;
    }
}

