/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.modules;

import java.util.Collection;
import java.util.Map;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.protocol.servlet.Processor;
import org.jboss.arquillian.protocol.servlet.ServletUtil;
import org.jboss.arquillian.protocol.servlet.arq514hack.descriptors.api.web.WebAppDescriptor;
import org.jboss.arquillian.protocol.servlet.v_2_5.ProtocolDeploymentAppender;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;

public abstract class AbstractModulesProtocolDeploymentPackager
implements DeploymentPackager {
    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        Archive archive = testDeployment.getApplicationArchive();
        WebArchive protocol = new ProtocolDeploymentAppender().createAuxiliaryArchive();
        Collection auxiliaryArchives = testDeployment.getAuxiliaryArchives();
        Processor processor = new Processor(testDeployment, processors);
        if (archive instanceof EnterpriseArchive) {
            EnterpriseArchive ear = (EnterpriseArchive)archive;
            Map wars = ear.getContent(Filters.include((String)".*\\.war"));
            for (Map.Entry warEntry : wars.entrySet()) {
                WebArchive war = (WebArchive)ear.getAsType(WebArchive.class, (ArchivePath)warEntry.getKey());
                this.handleWar(war, protocol, processor);
                this.addLibrariesToWar(war, auxiliaryArchives);
            }
            this.addLibrariesToEar(ear, auxiliaryArchives);
        } else if (archive instanceof WebArchive) {
            WebArchive war = (WebArchive)archive;
            this.handleWar(war, protocol, processor);
            war.addAsLibraries(auxiliaryArchives);
        } else {
            throw new IllegalArgumentException("Can only handle .war or .ear: " + archive);
        }
        return archive;
    }

    protected abstract void addLibrariesToWar(WebArchive var1, Collection<Archive<?>> var2);

    protected abstract void addLibrariesToEar(EnterpriseArchive var1, Collection<Archive<?>> var2);

    private Archive<?> handleWar(WebArchive war, WebArchive protocol, Processor processor) {
        if (war.contains(ServletUtil.WEB_XML_PATH)) {
            WebAppDescriptor applicationWebXml = (WebAppDescriptor)Descriptors.importAs(WebAppDescriptor.class).fromStream(war.get(ServletUtil.WEB_XML_PATH).getAsset().openStream());
            war.delete(ServletUtil.WEB_XML_PATH);
            war.setWebXML((Asset)new StringAsset(AbstractModulesProtocolDeploymentPackager.mergeWithDescriptor(applicationWebXml).exportAsString()));
            war.merge((Archive)protocol, Filters.exclude((String)".*web\\.xml.*"));
        } else {
            war.merge((Archive)protocol);
        }
        processor.process((Archive)war);
        return war;
    }

    static WebAppDescriptor mergeWithDescriptor(WebAppDescriptor descriptor) {
        descriptor.servlet("ArquillianServletRunner", "org.jboss.arquillian.protocol.servlet.runner.ServletTestRunner", new String[]{"/ArquillianServletRunner"});
        return descriptor;
    }
}

