/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.modules;

import org.jboss.arquillian.protocol.modules.ModuleContext;
import org.jboss.arquillian.protocol.modules.OperateOnModule;

class ModuleContextWrapper
implements ModuleContext {
    private static final String DOT = "-dot-";
    private ModuleContext context;
    private OperateOnModule oom;

    ModuleContextWrapper(ModuleContext context, OperateOnModule oom) {
        this.context = context;
        this.oom = oom;
    }

    @Override
    public String getModule() {
        return this.context.getModule();
    }

    @Override
    public String getHost() {
        String module;
        String version;
        if (this.oom == null) {
            return this.context.getHost();
        }
        StringBuilder host = new StringBuilder();
        int instance = this.oom.instance();
        if (instance > 0) {
            host.append(instance).append(DOT);
        }
        if ((version = this.oom.version()) != null && version.trim().length() > 0) {
            host.append(version).append(DOT);
        }
        if ((module = this.getModule()) != null) {
            host.append(module).append(DOT);
        }
        host.append(this.context.getHost());
        return host.toString();
    }

    @Override
    public int getPort() {
        return this.context.getPort();
    }
}

