/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.modules;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.modules.Cookies;
import org.jboss.arquillian.protocol.modules.ModulesProtocolConfiguration;
import org.jboss.arquillian.protocol.modules.ModulesServletURIHandler;
import org.jboss.arquillian.protocol.servlet.ServletMethodExecutor;

public class ModulesServletExecutor
extends ServletMethodExecutor {
    public ModulesServletExecutor(ModulesProtocolConfiguration configuration, ProtocolMetaData protocolMetaData, CommandCallback callback) {
        this.config = configuration;
        this.callback = callback;
        this.uriHandler = new ModulesServletURIHandler(configuration, protocolMetaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(String url, Class<T> returnType, Object requestObject) throws Exception {
        URLConnection connection = new URL(url).openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new IllegalStateException("Not an http connection! " + connection);
        }
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        httpConnection.setUseCaches(false);
        httpConnection.setDefaultUseCaches(false);
        httpConnection.setDoInput(true);
        this.prepareHttpConnection(httpConnection);
        try {
            if (requestObject != null) {
                httpConnection.setRequestMethod("POST");
                httpConnection.setDoOutput(true);
                httpConnection.setRequestProperty("Content-Type", "application/octet-stream");
            }
            if (requestObject != null) {
                ObjectOutputStream ous = new ObjectOutputStream(httpConnection.getOutputStream());
                try {
                    ous.writeObject(requestObject);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Error sending request Object, " + requestObject, e2);
                }
                finally {
                    ous.flush();
                    ous.close();
                }
            }
            try {
                httpConnection.getResponseCode();
            }
            catch (ConnectException e) {
                T e2 = null;
                httpConnection.disconnect();
                return e2;
            }
            if (httpConnection.getResponseCode() == 200) {
                Object o;
                ObjectInputStream ois = new ObjectInputStream(httpConnection.getInputStream());
                try {
                    o = ois.readObject();
                }
                finally {
                    ois.close();
                }
                if (!returnType.isInstance(o)) {
                    throw new IllegalStateException("Error reading results, expected a " + returnType.getName() + " but got " + o);
                }
                T t = returnType.cast(o);
                return t;
            }
            if (httpConnection.getResponseCode() == 204) {
                T t = null;
                return t;
            }
            if (httpConnection.getResponseCode() != 404) {
                throw new IllegalStateException("Error launching test at " + url + ". " + "Got " + httpConnection.getResponseCode() + " (" + httpConnection.getResponseMessage() + ")");
            }
        }
        finally {
            httpConnection.disconnect();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareHttpConnection(HttpURLConnection connection) {
        if (Cookies.hasCookies()) {
            try {
                String cookies = Cookies.getCookies();
                connection.setRequestProperty("Cookie", cookies);
            }
            finally {
                Cookies.removeCookies();
            }
        }
    }
}

