/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.modules;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.protocol.modules.ModuleContext;
import org.jboss.arquillian.protocol.modules.ModuleContextWrapper;
import org.jboss.arquillian.protocol.modules.ModuleMetaData;
import org.jboss.arquillian.protocol.modules.ModulesProtocolConfiguration;
import org.jboss.arquillian.protocol.modules.OperateOnModule;
import org.jboss.arquillian.protocol.servlet.ServletProtocolConfiguration;
import org.jboss.arquillian.protocol.servlet.ServletURIHandler;

public class ModulesServletURIHandler
extends ServletURIHandler {
    private ModulesProtocolConfiguration configuration;
    private Collection<HTTPContext> httpContexts;
    private Collection<ModuleMetaData> modules;

    private static Collection<HTTPContext> getHTTPContext(ProtocolMetaData protocolMetaData) {
        Collection contexts = protocolMetaData.getContexts(HTTPContext.class);
        if (contexts != null && contexts.size() > 0) {
            return contexts;
        }
        return Collections.singleton(null);
    }

    public ModulesServletURIHandler(ModulesProtocolConfiguration config, ProtocolMetaData protocolMetaData) {
        super((ServletProtocolConfiguration)config, ModulesServletURIHandler.getHTTPContext(protocolMetaData));
        this.configuration = config;
        this.httpContexts = protocolMetaData.getContexts(HTTPContext.class);
        this.modules = protocolMetaData.getContexts(ModuleMetaData.class);
    }

    protected HTTPContext locateHTTPContext(Method method) {
        HTTPContext context;
        HTTPContext previous = null;
        if (this.httpContexts != null && this.httpContexts.size() > 0) {
            previous = super.locateHTTPContext(method);
        }
        ModuleContext mc = this.locateModuleContext(method);
        if (previous == null) {
            context = new HTTPContext(mc.getHost(), mc.getPort());
            this.addArquillianServlet(context);
        } else {
            context = new HTTPContext(previous.getName(), mc.getHost(), mc.getPort());
            boolean foundArqServlet = false;
            for (Servlet servlet : previous.getServlets()) {
                if (!foundArqServlet && "ArquillianServletRunner".equals(servlet.getName())) {
                    foundArqServlet = true;
                }
                context.add(servlet);
            }
            if (!foundArqServlet) {
                this.addArquillianServlet(context);
            }
        }
        return context;
    }

    protected void addArquillianServlet(HTTPContext context) {
        Servlet servlet = new Servlet("ArquillianServletRunner", "");
        context.add(servlet);
    }

    protected ModuleContext locateModuleContext(Method method) {
        String host;
        String module = "default";
        OperateOnModule oom = method.getAnnotation(OperateOnModule.class);
        if (oom != null) {
            module = oom.value();
        }
        for (ModuleMetaData mmd : this.modules) {
            if (!module.equals(mmd.getModule())) continue;
            return new ModuleContextWrapper(mmd, oom);
        }
        if (this.configuration.isFailOnMissingModule()) {
            throw new IllegalStateException(String.format("No matching module %s - %s", module, this.modules));
        }
        String h = this.configuration.getProperty(module + ".host");
        String p = this.configuration.getProperty(module + ".port");
        String string = host = h != null ? h : "localhost";
        int port = p != null ? Integer.parseInt(p) : (this.configuration.getPort() != null ? this.configuration.getPort() : 8080);
        ModuleMetaData mmd = new ModuleMetaData(null, host, port);
        return new ModuleContextWrapper(mmd, oom);
    }
}

