/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.arquillian.spi.ApplicationArchiveProcessor;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.testing.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.container.ClassContainer;

public class OSGiApplicationArchiveProcessor
implements ApplicationArchiveProcessor {
    public void process(Archive<?> applicationArchive, TestClass testClass) {
        this.enhanceApplicationArchive(applicationArchive, testClass);
        this.assertValidBundleArchive(applicationArchive);
    }

    private void enhanceApplicationArchive(Archive<?> appArchive, TestClass testClass) {
        if (!ClassContainer.class.isAssignableFrom(appArchive.getClass())) {
            throw new IllegalArgumentException("ClassContainer expected: " + appArchive);
        }
        Class javaClass = testClass.getJavaClass();
        String path = javaClass.getName().replace('.', '/') + ".class";
        if (!appArchive.contains(path)) {
            ((ClassContainer)appArchive).addClass(javaClass);
        }
        final OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
        Manifest manifest = this.getBundleManifest(appArchive);
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
                String key = entry.getKey().toString();
                String value = (String)entry.getValue();
                if (key.equals("Manifest-Version")) continue;
                if (key.equals("Import-Package")) {
                    String[] imports = value.split(",");
                    builder.addImportPackages(imports);
                    continue;
                }
                if (key.equals("Export-Package")) {
                    String[] exports = value.split(",");
                    builder.addExportPackages(exports);
                    continue;
                }
                builder.addManifestHeader(key, value);
            }
        } else {
            builder.addBundleManifestVersion(2);
            builder.addBundleSymbolicName(appArchive.getName());
        }
        builder.addExportPackages(new Class[]{javaClass});
        this.addImportsForClass(builder, javaClass);
        builder.addImportPackages(new String[]{"org.jboss.arquillian.api", "org.jboss.arquillian.junit"});
        builder.addImportPackages(new String[]{"org.jboss.shrinkwrap.api", "org.jboss.shrinkwrap.api.asset", "org.jboss.shrinkwrap.api.spec"});
        builder.addImportPackages(new String[]{"org.junit", "org.junit.runner", "javax.inject", "org.osgi.framework"});
        builder.addImportPackages(new String[]{"org.jboss.osgi.spi.util", "org.jboss.osgi.testing"});
        appArchive.add(new Asset(){

            public InputStream openStream() {
                return builder.openStream();
            }
        }, "META-INF/MANIFEST.MF");
    }

    private void addImportsForClass(OSGiManifestBuilder builder, Class<?> javaClass) {
        for (Class<?> interf : javaClass.getInterfaces()) {
            this.addImportPackage(builder, interf);
        }
        for (Annotation anno : javaClass.getDeclaredAnnotations()) {
            this.addImportPackage(builder, anno.annotationType());
        }
        for (Field field : javaClass.getDeclaredFields()) {
            Class<?> type = field.getType();
            this.addImportPackage(builder, type);
        }
        for (Method method : javaClass.getDeclaredMethods()) {
            Class<?> returnType = method.getReturnType();
            if (returnType != Void.TYPE) {
                this.addImportPackage(builder, returnType);
            }
            for (Class<?> paramType : method.getParameterTypes()) {
                this.addImportPackage(builder, paramType);
            }
        }
        for (Class<?> declaredClass : javaClass.getDeclaredClasses()) {
            this.addImportsForClass(builder, declaredClass);
        }
    }

    private void addImportPackage(OSGiManifestBuilder builder, Class<?> type) {
        if (type.isArray()) {
            type = type.getComponentType();
        }
        if (!type.isPrimitive() && !type.getName().startsWith("java.")) {
            builder.addImportPackages(new Class[]{type});
        }
        for (Annotation anno : type.getDeclaredAnnotations()) {
            Class<? extends Annotation> anType = anno.annotationType();
            if (anType.getName().startsWith("java.")) continue;
            builder.addImportPackages(new Class[]{anType});
        }
    }

    private void assertValidBundleArchive(Archive<?> archive) {
        try {
            Manifest manifest = this.getBundleManifest(archive);
            BundleInfo.validateBundleManifest((Manifest)manifest);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Not a valid OSGi bundle: " + archive, ex);
        }
    }

    private Manifest getBundleManifest(Archive<?> archive) {
        try {
            Node node = archive.get("META-INF/MANIFEST.MF");
            if (node == null) {
                return null;
            }
            Manifest manifest = new Manifest(node.getAsset().openStream());
            return manifest;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

