/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.protocol.jmx.RepositoryArchiveLocator;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.arquillian.spi.TestDeployment;
import org.jboss.shrinkwrap.api.Archive;
import org.osgi.framework.BundleException;

public abstract class AbstractDeployableContainer
implements DeployableContainer {
    private static final Logger log = Logger.getLogger(AbstractDeployableContainer.class.getName());
    private BundleList supportBundles = new BundleList();

    public void setup(Context context, Configuration configuration) {
        log.fine("Setup OSGi Container");
    }

    public void start(Context context) throws LifecycleException {
        log.fine("Start OSGi Container");
    }

    public void stop(Context context) throws LifecycleException {
        log.fine("Stop OSGi Container");
    }

    protected void installSupportBundles() {
        try {
            if (!this.isJMXTestRunnerAvailable()) {
                BundleHandle handle = this.installSupportBundle("arquillian-osgi-bundle", true);
                this.supportBundles.add(handle);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot install support bundles", ex);
        }
    }

    private boolean isJMXTestRunnerAvailable() {
        try {
            MBeanServerConnection mbeanServer = this.getMBeanServerConnection();
            return mbeanServer.isRegistered(JMXTestRunnerMBean.OBJECT_NAME);
        }
        catch (IOException e) {
            return false;
        }
    }

    protected void uninstallSupportBundles() {
        this.uninstallBundleList(this.supportBundles);
    }

    public ContainerMethodExecutor deploy(Context context, Archive<?> archive) throws DeploymentException {
        TestDeployment deployment = (TestDeployment)context.get(TestDeployment.class);
        BundleList bundleList = new BundleList();
        context.add(BundleList.class, (Object)bundleList);
        BundleHandle appHandle = this.installInternal(context, archive);
        bundleList.add(appHandle);
        for (Archive auxArchive : deployment.getAuxiliaryArchives()) {
            BundleHandle auxHandle = this.installInternal(context, auxArchive);
            bundleList.add(auxHandle);
        }
        this.resolveInternal(context, appHandle);
        return this.getContainerMethodExecutor();
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        BundleList bundleList = (BundleList)context.get(BundleList.class);
        this.uninstallBundleList(bundleList);
    }

    private void uninstallBundleList(BundleList bundleList) {
        Collections.reverse(bundleList);
        for (BundleHandle handle : bundleList) {
            if (this.getBundleState(handle) == 1) continue;
            this.uninstallInternal(handle);
        }
        bundleList.clear();
    }

    private BundleHandle installInternal(Context context, Archive<?> archive) throws DeploymentException {
        try {
            log.fine("Installing bundle: " + archive.getName());
            return this.installBundle(archive);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new DeploymentException("Cannot install bundle: " + archive.getName(), (Throwable)ex);
        }
    }

    private void resolveInternal(Context context, BundleHandle handle) throws DeploymentException {
        try {
            log.fine("Resolve bundle: " + handle.getSymbolicName());
            this.resolveBundle(handle);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new DeploymentException("Cannot resolve bundle: " + handle, (Throwable)ex);
        }
    }

    private void uninstallInternal(BundleHandle handle) {
        try {
            log.fine("Uninstalling bundle: " + handle.getSymbolicName());
            this.uninstallBundle(handle);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Cannot uninstall bundle: " + handle, ex);
        }
    }

    public abstract MBeanServerConnection getMBeanServerConnection();

    public abstract ContainerMethodExecutor getContainerMethodExecutor();

    public abstract BundleHandle installBundle(Archive<?> var1) throws BundleException, IOException;

    public abstract BundleHandle installBundle(URL var1) throws BundleException, IOException;

    public abstract void resolveBundle(BundleHandle var1) throws BundleException, IOException;

    public abstract void uninstallBundle(BundleHandle var1) throws BundleException, IOException;

    public abstract int getBundleState(BundleHandle var1);

    public abstract void startBundle(BundleHandle var1) throws BundleException;

    public abstract void stopBundle(BundleHandle var1) throws BundleException;

    public abstract boolean isBundleInstalled(String var1);

    private BundleHandle installSupportBundle(String artifactId, boolean startBundle) throws BundleException, IOException {
        URL artifactURL = RepositoryArchiveLocator.getArtifactURL(null, (String)artifactId, null);
        if (artifactURL != null) {
            BundleHandle handle = this.installSupportFile(artifactURL, startBundle);
            return handle;
        }
        return null;
    }

    private BundleHandle installSupportFile(URL bundleURL, boolean startBundle) throws BundleException, IOException {
        BundleHandle handle = this.installBundle(bundleURL);
        if (startBundle) {
            this.startBundle(handle);
        }
        return handle;
    }

    static class BundleList
    extends ArrayList<BundleHandle> {
        BundleList() {
        }
    }

    public static class BundleHandle {
        private long bundleId;
        private String symbolicName;

        public BundleHandle(long bundleId, String symbolicName) {
            this.bundleId = bundleId;
            this.symbolicName = symbolicName;
        }

        public long getBundleId() {
            return this.bundleId;
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public String toString() {
            return "[" + this.bundleId + "]" + this.symbolicName;
        }
    }
}

