/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi.internal;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jboss.arquillian.osgi.ArchiveProvider;
import org.jboss.arquillian.osgi.internal.AbstractOSGiContainer;
import org.jboss.arquillian.osgi.internal.InternalArchiveProvider;
import org.jboss.arquillian.protocol.jmx.JMXServerFactory;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class InternalArchiveProviderImpl
implements InternalArchiveProvider {
    private static final Logger log = Logger.getLogger(InternalArchiveProviderImpl.class);
    private final ArchiveProvider delegate;
    private final ObjectName objectName;

    public InternalArchiveProviderImpl(TestClass testCase, ArchiveProvider provider) {
        this.delegate = provider;
        this.objectName = AbstractOSGiContainer.getArchiveProviderName(testCase);
    }

    public void registerMBean() throws JMException {
        MBeanServer mbeanServer = JMXServerFactory.findOrCreateMBeanServer();
        if (!mbeanServer.isRegistered(this.objectName)) {
            log.debug((Object)("Register: " + this.objectName));
            StandardMBean mbean = new StandardMBean(this, InternalArchiveProvider.class);
            mbeanServer.registerMBean(mbean, this.objectName);
        }
    }

    public void unregisterMBean() {
        MBeanServer mbeanServer = JMXServerFactory.findOrCreateMBeanServer();
        if (mbeanServer.isRegistered(this.objectName)) {
            try {
                log.debug((Object)("Unregister: " + this.objectName));
                mbeanServer.unregisterMBean(this.objectName);
            }
            catch (JMException ex) {
                log.error((Object)("Cannot unregister: " + this.objectName));
            }
        }
    }

    public byte[] getTestArchive(String name) {
        JavaArchive archive = this.delegate.getTestArchive(name);
        ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.exportZip((OutputStream)baos);
        return baos.toByteArray();
    }
}

